/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.partreader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.partreader.BGZPartReader;
import edu.sysu.pmglab.io.partreader.NoPartReader;
import edu.sysu.pmglab.io.partreader.TextPartReader;
import edu.sysu.pmglab.io.reader.ReaderStream;
import java.io.IOException;

public interface IPartReader {
    public static IPartReader instanceOf(String address) throws IOException {
        return IPartReader.instanceOf(LiveFile.of(address));
    }

    public static IPartReader instanceOf(LiveFile file) throws IOException {
        if (file.getFileType() == FileType.HTTP || file.getFileType() == FileType.SFTP) {
            return new NoPartReader(file);
        }
        if (file.isBGZCompressed()) {
            return new BGZPartReader(file);
        }
        if (file.isGZCompressed()) {
            return new NoPartReader(file);
        }
        return new TextPartReader(file);
    }

    public List<ReaderStream> part(int var1) throws IOException;

    public Bytes readline() throws IOException;

    public int readline(ByteStream var1) throws IOException;

    public void close() throws IOException;
}

