/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.partreader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.partreader.IPartReader;
import edu.sysu.pmglab.io.reader.ReaderStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class NoPartReader
implements IPartReader {
    final ReaderStream reader;
    final AtomicBoolean isPart = new AtomicBoolean(false);

    public NoPartReader(LiveFile file) throws IOException {
        this.reader = file.openAsText();
    }

    @Override
    public List<ReaderStream> part(int nThreads) throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked readers");
        }
        this.isPart.set(true);
        return List.wrap(new ReaderStream[]{this.reader});
    }

    @Override
    public Bytes readline() throws IOException {
        return this.reader.readline();
    }

    @Override
    public int readline(ByteStream line) throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked readers");
        }
        return this.reader.readline(line);
    }

    @Override
    public void close() throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked readers");
        }
        this.reader.close();
    }
}

