/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.partreader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.partreader.BoundReader;
import edu.sysu.pmglab.io.partreader.IPartReader;
import edu.sysu.pmglab.io.reader.ReaderStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class TextPartReader
implements IPartReader {
    final ReaderStream reader;
    final LiveFile file;
    final AtomicBoolean isPart = new AtomicBoolean(false);

    TextPartReader(LiveFile file) throws IOException {
        this.reader = new ReaderStream(file.openAsBinary());
        this.file = file;
    }

    @Override
    public synchronized List<ReaderStream> part(int nParts) throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked reader");
        }
        long currentSeek = this.reader.tell();
        long resSize = this.reader.length() - currentSeek;
        if (nParts == 1 || resSize <= 0xA00000L) {
            this.isPart.set(true);
            return List.wrap(new ReaderStream[]{this.reader});
        }
        List<ReaderStream> readers = new List<ReaderStream>();
        long eachBlockSize = resSize / (long)nParts + (long)(resSize % (long)nParts == 0L ? 0 : 1);
        long startBound = currentSeek;
        long endBound = currentSeek + eachBlockSize;
        ByteStream cache = new ByteStream();
        while (startBound < endBound) {
            this.reader.seek(endBound);
            this.reader.adjustLine();
            endBound = this.reader.tell();
            readers.add(new ReaderStream(new BoundReader(this.file.openAsBinary(), new LongInterval(startBound, endBound))));
            startBound = endBound;
            endBound = Math.min(currentSeek + resSize, endBound + eachBlockSize);
        }
        this.isPart.set(true);
        this.reader.close();
        return readers;
    }

    @Override
    public Bytes readline() throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked reader");
        }
        ByteStream cache = ByteStream.getThreadInstance();
        if (this.readline(cache) != -1) {
            return cache.toBytes(true);
        }
        return null;
    }

    @Override
    public int readline(ByteStream line) throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked reader");
        }
        return this.reader.readline(line);
    }

    @Override
    public void close() throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked reader");
        }
        this.reader.close();
    }
}

