/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.reader;

import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

public final class ChannelReaderStream
extends ISeekableReaderStream {
    final FileChannel reader;
    final File file;
    final ByteBuffer buffer = ByteBuffer.allocateDirect(8192);

    public ChannelReaderStream(LocalFile file) throws IOException {
        this(new File(file.getPath()));
    }

    public ChannelReaderStream(File file) throws IOException {
        this.reader = FileChannel.open(file.toPath(), StandardOpenOption.READ);
        this.file = file;
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        if (len > this.buffer.capacity()) {
            ByteBuffer buf = ByteBuffer.wrap(dst, off, len);
            return this.reader.read(buf);
        }
        this.buffer.clear();
        this.buffer.limit(len);
        int bytesRead = this.reader.read(this.buffer);
        if (bytesRead == -1) {
            return -1;
        }
        this.buffer.flip();
        this.buffer.get(dst, off, bytesRead);
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.reader.position(pos);
    }

    @Override
    public long tell() throws IOException {
        return this.reader.position();
    }

    @Override
    public long length() throws IOException {
        return this.reader.size();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long pointer = this.tell();
        this.seek(pointer + n);
        return this.tell() - pointer;
    }
}

