/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.reader;

import edu.sysu.pmglab.io.reader.IReaderStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GZIPReaderStream
extends IReaderStream {
    final GZIPInputStream reader;

    public GZIPReaderStream(InputStream stream) throws IOException {
        this.reader = new GZIPInputStream(stream, 16384);
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        int total = 0;
        boolean reachEOF = false;
        while (len > 0) {
            int length0 = this.reader.read(dst, off, len);
            if (length0 == -1) {
                if (!reachEOF) {
                    reachEOF = true;
                    continue;
                }
                return total == 0 ? -1 : total;
            }
            total += length0;
            len -= length0;
            off += length0;
        }
        return total;
    }

    @Override
    public int available() throws IOException {
        return this.reader.available();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

