/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.reader;

import edu.sysu.pmglab.io.file.HTTPFile;
import edu.sysu.pmglab.io.reader.EmptyReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.utils.ValueUtils;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpReaderStream
extends ISeekableReaderStream {
    private final HTTPFile file;
    private final OkHttpClient client;
    private Response response;
    private InputStream reader;
    private long pointer = 0L;
    private boolean isClosed = false;
    private byte[] skipBuffer;
    private long lastTime = System.currentTimeMillis();

    public HttpReaderStream(HTTPFile file) {
        this.file = file;
        this.client = file.getClient();
        this.reader = EmptyReaderStream.INSTANCE();
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        int read;
        if (this.isClosed) {
            throw new IllegalStateException("Stream closed");
        }
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (this.response == null) {
            if (this.file.length() == 0L || this.pointer == this.file.length()) {
                return -1;
            }
            this.openConnection(this.pointer);
        }
        int totalRead = 0;
        while (len > 0 && (read = this.reader.read(dst, off, len)) != -1) {
            off += read;
            len -= read;
            this.pointer += (long)read;
            totalRead += read;
        }
        return totalRead > 0 ? totalRead : -1;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.closeCurrentConnection();
        this.client.dispatcher().executorService().shutdown();
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Stream closed");
        }
        if ((pos = ValueUtils.valueOf(pos, 0L, this.file.length())) == this.pointer) {
            return;
        }
        if (pos > this.pointer && pos - this.pointer <= 8192L) {
            if (this.skipBuffer == null) {
                this.skipBuffer = new byte[8192];
            }
            this.read(this.skipBuffer, 0, (int)(pos - this.pointer));
            return;
        }
        if (!this.file.isSeekable()) {
            throw new UnsupportedOperationException("Seek not supported: " + this.file.getPath());
        }
        this.closeCurrentConnection();
        this.pointer = pos;
    }

    @Override
    public long tell() {
        return this.pointer;
    }

    @Override
    public long length() {
        return this.file.length();
    }

    private void openConnection(long start) throws IOException {
        this.closeCurrentConnection();
        long elapsed = System.currentTimeMillis() - this.lastTime;
        if (elapsed < 50L) {
            try {
                Thread.sleep(50L - elapsed);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        Request request = new Request.Builder().url(this.file.getURL()).header("Accept-Encoding", "identity").header("Range", "bytes=" + start + "-" + (this.file.length() > 0L ? Long.valueOf(this.file.length() - 1L) : "")).build();
        this.response = this.client.newCall(request).execute();
        if (!this.response.isSuccessful()) {
            throw new IOException("Unexpected code " + this.response);
        }
        this.reader = this.response.body().byteStream();
        this.lastTime = System.currentTimeMillis();
    }

    private void closeCurrentConnection() {
        try {
            if (this.response != null) {
                this.response.close();
                this.reader.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.response = null;
            this.reader = EmptyReaderStream.INSTANCE();
        }
    }
}

