/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.reader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.VarIntCodec;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.container.array.EmptyArray;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public abstract class IReaderStream
extends InputStream {
    Bytes out;

    @Override
    public int read() throws IOException {
        int n;
        if (this.out == null) {
            this.out = new Bytes(9, true);
        }
        if ((n = this.read(this.out.bytes(), 0, 1)) == 1) {
            return this.out.fastByteAt(0) & 0xFF;
        }
        return -1;
    }

    @Override
    public final int read(byte[] dst) throws IOException {
        return this.read(dst, 0, dst.length);
    }

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract int available() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public final void mark(int readlimit) {
    }

    @Override
    public final void reset() throws IOException {
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    public final byte[] read(int n) throws IOException {
        if (n == 0) {
            return EmptyArray.BYTE;
        }
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        byte[] out = new byte[n];
        int length = this.read(out);
        if (length == -1) {
            return EmptyArray.BYTE;
        }
        if (length == n) {
            return out;
        }
        return Arrays.copyOfRange(out, 0, length);
    }

    public final Bytes readAll() throws IOException {
        int len;
        ByteStream writer = new ByteStream(8192, true);
        byte[] cache = new byte[8192];
        while ((len = this.read(cache)) != -1) {
            writer.write(cache, 0, len);
        }
        return writer.toBytes();
    }

    public final Bytes readBytes(int n) throws IOException {
        if (n == 0) {
            return Bytes.EMPTY;
        }
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        byte[] out = new byte[n];
        int length = this.read(out);
        if (length == -1) {
            return Bytes.EMPTY;
        }
        return new Bytes(out, 0, length);
    }

    public final int readVarInt32() throws IOException {
        long value;
        if (this.out == null) {
            this.out = new Bytes(9, true);
        }
        if ((value = VarIntCodec.decode(this, this.out.bytes())) < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new CCFComponentException("Value exceeds the defined range (-2147483648 ~ 2147483647)");
        }
        return (int)value;
    }

    public final long readVarInt64() throws IOException {
        if (this.out == null) {
            this.out = new Bytes(9, true);
        }
        return VarIntCodec.decode(this, this.out.bytes());
    }

    public final long readLong() throws IOException {
        if (this.out == null) {
            this.out = new Bytes(9, true);
        }
        this.rRequire(this.read(this.out.bytes(), 0, 8), 8);
        this.out.reset(0, 8);
        return this.out.decodeLong();
    }

    public final int readInt() throws IOException {
        if (this.out == null) {
            this.out = new Bytes(9, true);
        }
        this.rRequire(this.read(this.out.bytes(), 0, 4), 4);
        this.out.reset(0, 4);
        return this.out.decodeInt();
    }

    public final short readShort() throws IOException {
        if (this.out == null) {
            this.out = new Bytes(9, true);
        }
        this.rRequire(this.read(this.out.bytes(), 0, 2), 2);
        this.out.reset(0, 2);
        return this.out.decodeShort();
    }

    public final int read(ByteStream buffer, int length) throws IOException {
        return buffer.transferFrom(this, length);
    }

    public void rRequire(int provided, int required) {
        if (provided < required) {
            throw new IndexOutOfBoundsException("Requested " + required + " bytes, but only " + provided + " bytes provided");
        }
    }
}

