/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.reader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.io.reader.IReaderStream;
import edu.sysu.pmglab.utils.ValueUtils;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ISeekableReaderStream
extends IReaderStream {
    public abstract void seek(long var1) throws IOException;

    public abstract long tell() throws IOException;

    public abstract long length() throws IOException;

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.seek(this.tell() + n);
        long c = this.tell();
        return c - n;
    }

    @Override
    public int available() throws IOException {
        return (int)ValueUtils.valueOf(this.length() - this.tell(), 0L, 0x7FFFFFFDL);
    }

    public void transferTo(long pos, long length, OutputStream output) throws IOException {
        int readInLength;
        this.seek(pos);
        if (pos != this.tell()) {
            throw new IOException("Unable to reach the position of the file pointer at " + pos);
        }
        ByteStream bytes = ByteStream.getThreadInstance();
        while (length > 0L && (readInLength = this.read(bytes.bytes(), 0, (int)Math.min(length, (long)bytes.capacity()))) != -1) {
            output.write(bytes.bytes(), 0, readInLength);
            length -= (long)readInLength;
        }
    }
}

