/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.reader;

import edu.sysu.pmglab.io.reader.IReaderStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamWrapper
extends IReaderStream {
    final InputStream reader;

    public InputStreamWrapper(InputStream reader) {
        this.reader = reader;
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        int length0;
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        int total = 0;
        while (len > 0 && (length0 = this.reader.read(dst, off, len)) != -1) {
            off += length0;
            len -= length0;
            total += length0;
        }
        return total == 0 ? -1 : total;
    }

    @Override
    public int available() throws IOException {
        return this.reader.available();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }
}

