/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.reader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.io.bgzip.BGZIPReaderStream;
import edu.sysu.pmglab.io.file.DockerFile;
import edu.sysu.pmglab.io.file.HTTPFile;
import edu.sysu.pmglab.io.file.SFTPFile;
import edu.sysu.pmglab.io.reader.ChannelReaderStream;
import edu.sysu.pmglab.io.reader.DockerReaderStream;
import edu.sysu.pmglab.io.reader.GZIPReaderStream;
import edu.sysu.pmglab.io.reader.HttpReaderStream;
import edu.sysu.pmglab.io.reader.IReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.reader.SFTPReaderStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

public class ReaderStream
extends ISeekableReaderStream {
    final IReaderStream reader;
    final ByteStream buffer;

    public ReaderStream(String address, Option mode) throws IOException {
        switch (mode) {
            case DEFAULT: {
                this.reader = new ChannelReaderStream(new File(address));
                break;
            }
            case BGZIP: {
                this.reader = new BGZIPReaderStream(new ChannelReaderStream(new File(address)));
                break;
            }
            case GZIP: {
                this.reader = new GZIPReaderStream(new ChannelReaderStream(new File(address)));
                break;
            }
            case HTTP: {
                this.reader = new ReaderStream(new HttpReaderStream(new HTTPFile(new URL(address))));
                break;
            }
            case DOCKER: {
                this.reader = new DockerReaderStream(new DockerFile(address));
                break;
            }
            case HTTP_BGZIP: {
                this.reader = new BGZIPReaderStream(new HttpReaderStream(new HTTPFile(new URL(address))));
                break;
            }
            case HTTP_GZIP: {
                this.reader = new GZIPReaderStream(new HttpReaderStream(new HTTPFile(new URL(address))));
                break;
            }
            case DOCKER_BGZIP: {
                this.reader = new BGZIPReaderStream(new DockerReaderStream(new DockerFile(address)));
                break;
            }
            case DOCKER_GZIP: {
                this.reader = new GZIPReaderStream(new DockerReaderStream(new DockerFile(address)));
                break;
            }
            case SFTP: {
                this.reader = new ReaderStream(new SFTPReaderStream(new SFTPFile.Path(address)));
                break;
            }
            case SFTP_BGZIP: {
                this.reader = new BGZIPReaderStream(new SFTPReaderStream(new SFTPFile.Path(address)));
                break;
            }
            case SFTP_GZIP: {
                this.reader = new GZIPReaderStream(new SFTPReaderStream(new SFTPFile.Path(address)));
                break;
            }
            default: {
                throw new IOException();
            }
        }
        this.buffer = new ByteStream(8192, false);
    }

    public ReaderStream(IReaderStream reader) {
        this(reader, 8192);
    }

    public ReaderStream(IReaderStream reader, int bufferSize) {
        this.reader = reader;
        this.buffer = new ByteStream(bufferSize, false);
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.rRemaining() > 0) {
            return this.buffer.read();
        }
        return super.read();
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        int total = 0;
        while (len > 0) {
            int length0;
            if (this.buffer.rRemaining() == 0) {
                if (len >= this.buffer.capacity()) {
                    this.buffer.clear();
                    length0 = this.reader.read(dst, off, len);
                    if (length0 == -1) break;
                    off += length0;
                    len -= length0;
                    total += length0;
                    continue;
                }
                if (this.fill() == -1 || (length0 = this.buffer.read(dst, off, len)) == -1) break;
                off += length0;
                len -= length0;
                total += length0;
                continue;
            }
            length0 = this.buffer.read(dst, off, len);
            if (length0 == -1) break;
            off += length0;
            len -= length0;
            total += length0;
        }
        return total == 0 ? -1 : total;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.buffer.close();
    }

    private int fill() throws IOException {
        int remaining = this.buffer.rRemaining();
        if (remaining == 0) {
            this.buffer.clear();
            return this.buffer.capacity() == 0 ? -1 : this.buffer.transferFrom(this.reader, this.buffer.capacity());
        }
        return remaining;
    }

    public Bytes readline() throws IOException {
        ByteStream container = ByteStream.getThreadInstance();
        if (this.readline(container) != -1) {
            return container.toBytes(true);
        }
        return null;
    }

    public int readline(ByteStream line) throws IOException {
        if (this.fill() == -1) {
            return -1;
        }
        int size = line.length();
        do {
            if (!this.buffer.readUntil(line, (byte)10, false)) continue;
            if (line.wTell() > 0 && line.bytes()[line.wTell() - 1] == 13) {
                line.wSeek(line.wTell() - 1);
            }
            return line.length() - size;
        } while (this.fill() != -1);
        int length0 = line.length() - size;
        if (length0 == 0) {
            return -1;
        }
        return length0;
    }

    public void adjustLine() throws IOException {
        block2: {
            int numOfBytes;
            if (this.fill() == -1) {
                return;
            }
            while ((numOfBytes = this.buffer.find((byte)10)) == -1) {
                this.buffer.clear();
                if (this.fill() != -1) continue;
                break block2;
            }
            this.buffer.rSkip(numOfBytes + 1);
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.reader instanceof ISeekableReaderStream) {
            long current = this.tell();
            if (current == pos) {
                return;
            }
            if (current < pos) {
                this.skip(pos - current);
            } else {
                long forward;
                if (this.buffer.rRemaining() > 0 && (forward = current - pos) <= (long)this.buffer.rTell()) {
                    this.buffer.rSeek((int)((long)this.buffer.rTell() - forward));
                    return;
                }
                this.buffer.clear();
                ((ISeekableReaderStream)this.reader).seek(pos);
            }
        } else {
            throw new IOException("The current I/O stream is not seekable");
        }
    }

    @Override
    public long tell() throws IOException {
        if (this.reader instanceof ISeekableReaderStream) {
            return ((ISeekableReaderStream)this.reader).tell() - (long)this.buffer.rRemaining();
        }
        throw new IOException("The current I/O stream is not seekable");
    }

    @Override
    public long length() throws IOException {
        if (this.reader instanceof ISeekableReaderStream) {
            return ((ISeekableReaderStream)this.reader).length();
        }
        throw new IOException("The current I/O stream is not seekable");
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long total = 0L;
        while (n > 0L) {
            int remaining = this.buffer.rRemaining();
            if (remaining > 0) {
                if ((long)remaining >= n) {
                    this.buffer.rSkip((int)n);
                    n -= n;
                    total += n;
                    continue;
                }
                this.buffer.clear();
                n -= (long)remaining;
                total += (long)remaining;
                continue;
            }
            this.buffer.clear();
            long skip = this.reader.skip(n);
            n -= skip;
            total += skip;
            break;
        }
        return total;
    }

    @Override
    public int available() throws IOException {
        int l = this.fill();
        return l == -1 ? 0 : l;
    }

    @Override
    public void transferTo(long pos, long len, OutputStream output) throws IOException {
        int readInLength;
        if (len == 0L) {
            return;
        }
        if (len < 0L) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        this.seek(pos);
        if (pos != this.tell()) {
            throw new IOException("Unable to reach the position of the file pointer at " + pos);
        }
        ByteStream bytes = ByteStream.getThreadInstance();
        while (len > 0L && (readInLength = this.read(bytes.bytes(), 0, (int)Math.min(len, (long)bytes.capacity()))) != -1) {
            output.write(bytes.bytes(), 0, readInLength);
            len -= (long)readInLength;
        }
    }

    public static enum Option {
        DEFAULT,
        GZIP,
        BGZIP,
        HTTP,
        HTTP_GZIP,
        HTTP_BGZIP,
        DOCKER,
        DOCKER_GZIP,
        DOCKER_BGZIP,
        SFTP,
        SFTP_GZIP,
        SFTP_BGZIP;

    }
}

