/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.reader;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import edu.sysu.pmglab.io.file.SFTPFile;
import edu.sysu.pmglab.io.reader.EmptyReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.ValueUtils;
import java.io.IOException;
import java.io.InputStream;

public class SFTPReaderStream
extends ISeekableReaderStream {
    private final SFTPFile file;
    long pointer = 0L;
    boolean isClosed = false;
    byte[] skip = null;
    private Session session;
    private ChannelSftp channel;
    private InputStream reader;

    public SFTPReaderStream(SFTPFile.Path address) throws IOException {
        this(new SFTPFile(address));
    }

    public SFTPReaderStream(SFTPFile file) throws IOException {
        try {
            this.file = file;
            if (this.file.length() == 0L) {
                this.reader = EmptyReaderStream.INSTANCE();
                this.session = null;
                this.channel = null;
            } else {
                this.session = file.createSession();
                this.channel = (ChannelSftp)this.session.openChannel("sftp");
                this.channel.connect();
                this.reader = this.channel.get(this.file.getSFTPPath().remotePath);
            }
        }
        catch (JSchException | SftpException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("IO Stream closed");
        }
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        long markPointer = this.pointer;
        int markOff = off;
        int markLen = len;
        try {
            int length0;
            int total = 0;
            while (len > 0 && (length0 = this.reader.read(dst, off, len)) != -1) {
                off += length0;
                len -= length0;
                this.pointer += (long)length0;
                total += length0;
            }
            return total == 0 ? -1 : total;
        }
        catch (IOException e) {
            try {
                int length0;
                this.pointer = markPointer;
                off = markOff;
                len = markLen;
                if (this.channel != null) {
                    this.channel.disconnect();
                }
                if (this.session != null) {
                    this.session.disconnect();
                }
                this.session = this.file.createSession();
                this.channel = (ChannelSftp)this.session.openChannel("sftp");
                this.channel.connect();
                this.reader = this.channel.get(this.file.getSFTPPath().remotePath, null, this.pointer);
                int total = 0;
                while (len > 0 && (length0 = this.reader.read(dst, off, len)) != -1) {
                    off += length0;
                    len -= length0;
                    this.pointer += (long)length0;
                    total += length0;
                }
                return total == 0 ? -1 : total;
            }
            catch (JSchException | SftpException ex) {
                if (this.channel != null) {
                    this.channel.disconnect();
                }
                if (this.session != null) {
                    this.session.disconnect();
                }
                this.isClosed = true;
                this.skip = null;
                throw new IOException(ex);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        this.isClosed = true;
        this.skip = null;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("IO Stream closed");
        }
        if ((pos = ValueUtils.valueOf(pos, 0L, this.length())) == this.pointer) {
            return;
        }
        if (pos == this.file.length()) {
            this.reader = EmptyReaderStream.INSTANCE();
            this.pointer = pos;
            return;
        }
        if (pos > this.pointer && pos <= this.pointer + 8192L) {
            if (this.skip == null) {
                this.skip = new byte[8192];
            }
            this.read(this.skip, 0, (int)(pos - this.pointer));
            Assert.that(this.pointer == pos);
            return;
        }
        try {
            this.reader.close();
            this.reader = this.channel.get(this.file.getSFTPPath().remotePath, null, pos);
            this.pointer = pos;
        }
        catch (SftpException e) {
            this.isClosed = true;
            this.channel.disconnect();
            throw new IOException(e);
        }
    }

    @Override
    public long tell() throws IOException {
        return this.pointer;
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }
}

