/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.text;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.indexable.FixedIndexableMap;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;

public class TextRecord {
    final IndexableSet<String> keys;
    final FixedIndexableMap<String, Bytes> values;

    public TextRecord(IndexableSet<String> keys2) {
        this.keys = keys2.asUnmodifiable();
        this.values = new FixedIndexableMap(this.keys);
    }

    public IndexableSet<String> keys() {
        return this.keys;
    }

    public List<Bytes> values() {
        List<Bytes> values2 = new List<Bytes>(this.keys.size());
        int l = this.keys.size();
        for (int i = 0; i < l; ++i) {
            values2.add(this.values.getByIndex(i));
        }
        return values2.asUnmodifiable();
    }

    public int size() {
        return this.keys.size();
    }

    public Bytes get(String field) {
        return this.values.get(field);
    }

    public Bytes gets(String ... fields) {
        for (String field : fields) {
            int index = this.keys.indexOf(field);
            if (index == -1) continue;
            return this.values.get(field);
        }
        throw new IllegalArgumentException("get value by unknown key: " + List.wrap(fields));
    }

    public Bytes get(int fieldIndex) {
        return this.values.getByIndex(fieldIndex);
    }

    public int indexOf(String field) {
        return this.keys.indexOf(field);
    }

    public String keyOf(int index) {
        return this.keys.valueOf(index);
    }

    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    public TextRecord set(int index, String value) {
        if (value == null) {
            this.values.putByIndex(index, null);
        } else if (value.length() == 0) {
            this.values.putByIndex(index, Bytes.EMPTY);
        } else {
            this.values.putByIndex(index, new Bytes(value));
        }
        return this;
    }

    public TextRecord setFrom(TextRecord source2, boolean fillNull) {
        if (source2 == null) {
            return this;
        }
        if (this.keys() == source2.keys()) {
            int l = this.keys.size();
            for (int i = 0; i < l; ++i) {
                this.values.putByIndex(i, source2.get(i));
            }
        } else if (fillNull) {
            int l = this.keys.size();
            for (int i = 0; i < l; ++i) {
                int sourceIndex = source2.indexOf(this.keys.valueOf(i));
                if (sourceIndex != -1) {
                    this.values.putByIndex(i, source2.get(sourceIndex));
                    continue;
                }
                this.values.putByIndex(i, null);
            }
        } else {
            int count = source2.size();
            int l = this.keys.size();
            for (int i = 0; i < l && count != 0; ++i) {
                int sourceIndex = source2.indexOf(this.keys.valueOf(i));
                if (sourceIndex == -1) continue;
                this.values.putByIndex(i, source2.get(sourceIndex));
                --count;
            }
        }
        return this;
    }

    public TextRecord set(String field, String value) {
        if (value == null) {
            this.values.put(field, null);
        } else if (value.length() == 0) {
            this.values.put(field, Bytes.EMPTY);
        } else {
            this.values.put(field, new Bytes(value));
        }
        return this;
    }

    public TextRecord set(String field, long value) {
        this.values.put(field, new Bytes(ASCIIUtility.toASCII(value)));
        return this;
    }

    public TextRecord set(String field, double value) {
        this.values.put(field, new Bytes(ASCIIUtility.toASCII(value)));
        return this;
    }

    public TextRecord set(int index, Bytes value) {
        this.values.putByIndex(index, value);
        return this;
    }

    public TextRecord set(String field, Bytes value) {
        this.values.put(field, value);
        return this;
    }

    public String toString() {
        Iterator<String> keys2 = this.keys.iterator();
        if (!keys2.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            String key = keys2.next();
            Bytes value = this.get(key);
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!keys2.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public void clear() {
        this.values.clear();
    }
}

