/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.text.reader;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.utils.Assert;
import java.util.function.BiConsumer;

public class CustomSeparator
implements ISeparator {
    private final BiConsumer<Bytes, List<Bytes>> function;

    public CustomSeparator(BiConsumer<Bytes, List<Bytes>> function) {
        Assert.that(function != null);
        this.function = function;
    }

    public CustomSeparator(String format) {
        Bytes rule = new Bytes(format);
        List<Bytes> keywords = new List<Bytes>();
        int index = 0;
        int offset = 0;
        while (index < rule.length()) {
            if (rule.fastByteAt(index) == 123 && index < rule.length() - 1 && rule.fastByteAt(index + 1) == 125) {
                if (index != offset) {
                    keywords.add(rule.subBytes(offset, index));
                }
                offset = index += 2;
                if (keywords.size() >= 1 && keywords.fastLastGet(0) == null) {
                    throw new IllegalArgumentException("Ambiguous format: adjacent placeholders without separators");
                }
                keywords.add(null);
                continue;
            }
            ++index;
        }
        if (index != offset) {
            keywords.add(rule.subBytes(offset, index));
        }
        this.function = keywords.size() == 0 ? (input, values2) -> {} : (input, values2) -> {
            int p = 0;
            block0: for (int i = 0; i < keywords.size(); ++i) {
                Bytes keyword = (Bytes)keywords.fastGet(i);
                if (keyword == null) {
                    if (i == keywords.size() - 1) {
                        values2.add(input.subBytes(p));
                        p = input.length();
                        continue;
                    }
                    Bytes nextKeyword = (Bytes)keywords.fastGet(i + 1);
                    if (nextKeyword == null) {
                        throw new IllegalArgumentException("Ambiguous format: adjacent placeholders without separators");
                    }
                    if (p + nextKeyword.length() > input.length()) {
                        throw new IllegalArgumentException("Input does not match the format: " + format);
                    }
                    block1: for (int j = p; j < input.length() - nextKeyword.length() + 1; ++j) {
                        for (int k = 0; k < nextKeyword.length(); ++k) {
                            if (input.fastByteAt(j + k) != nextKeyword.fastByteAt(k)) continue block1;
                        }
                        values2.add(input.subBytes(p, j));
                        p = j + nextKeyword.length();
                        ++i;
                        continue block0;
                    }
                    throw new IllegalArgumentException("Input does not match the format: " + format);
                }
                if (input.startsWith(keyword)) {
                    p += keyword.length();
                    continue;
                }
                throw new IllegalArgumentException("Input does not match the format: " + format);
            }
            if (p != input.length()) {
                throw new IllegalArgumentException("Input does not match the format: " + format);
            }
        };
    }

    public CustomSeparator(byte ... separators) {
        if (separators == null || separators.length == 0) {
            this.function = (bytes, values2) -> values2.add(bytes);
        } else if (separators.length == 1) {
            byte separator = separators[0];
            this.function = (bytes, values2) -> {
                int mark = 0;
                for (int i = 0; i < bytes.length(); ++i) {
                    if (bytes.fastByteAt(i) != separator) continue;
                    values2.add(bytes.subBytes(mark, i));
                    mark = i + 1;
                }
                values2.add(bytes.subBytes(mark));
            };
        } else {
            this.function = (bytes, values2) -> {
                int mark = 0;
                block0: for (int i = 0; i < bytes.length(); ++i) {
                    for (byte separator : separators) {
                        if (bytes.fastByteAt(i) != separator) continue;
                        values2.add(bytes.subBytes(mark, i));
                        mark = i + 1;
                        continue block0;
                    }
                }
                values2.add(bytes.subBytes(mark));
            };
        }
    }

    @Override
    public void accept(Bytes bytes, List<Bytes> container) {
        this.function.accept(bytes, container);
    }
}

