/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.text.reader;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.InvalidFieldException;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.reader.ISeparator;

public interface IHeaderParser {
    public static final IHeaderParser BEGIN_WITH_1_NUMBER_SIGN = IHeaderParser.beginWith("#", true);
    public static final IHeaderParser FIRST_LINE = IHeaderParser.beginWith("", false);
    public static final IHeaderParser NO_HEADER_LINE = (data, separator, header) -> false;

    public static IHeaderParser beginWith(String prefix, boolean removePrefix) {
        Bytes marker = new Bytes(prefix);
        return (data, separator, header) -> {
            if (data.startsWith(marker)) {
                List<String> cutValues = removePrefix ? separator.accept(data.subBytes(marker.length())).apply(Bytes::toString) : separator.accept(data).apply(Bytes::toString);
                for (String fieldName : cutValues) {
                    if (fieldName == null || fieldName.length() == 0) {
                        fieldName = "_";
                    }
                    if (header.contains(fieldName)) {
                        int dupIndex = 1;
                        while (header.contains(fieldName = (fieldName.endsWith("_") ? "" : "_") + dupIndex)) {
                            ++dupIndex;
                        }
                    }
                    header.add(fieldName);
                }
                return true;
            }
            return false;
        };
    }

    public static IHeaderParser assign(boolean returns, boolean checkLength, String ... headers) {
        if (checkLength) {
            return (data, separator, header) -> {
                List<Bytes> firstLine = separator.accept(data);
                if (firstLine.size() != headers.length) {
                    throw new InvalidFieldException("Requires 6 column fields, but " + firstLine.size() + " were provided");
                }
                header.addAll(headers);
                return returns;
            };
        }
        return (data, separator, header) -> {
            header.addAll(headers);
            return returns;
        };
    }

    public boolean parse(Bytes var1, ISeparator var2, IndexableSet<String> var3);
}

