/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.text.reader;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.io.text.reader.ISeparator;

public enum Separator implements ISeparator
{
    BLANK(new CustomSeparator((bytes, values2) -> {
        int mark = 0;
        int length = bytes.length();
        for (int start = 0; start < length; ++start) {
            if (bytes.fastByteAt(start) != 32 && bytes.fastByteAt(start) != 9) continue;
            values2.add(bytes.subBytes(mark, start));
            mark = start + 1;
        }
        values2.add(bytes.subBytes(mark));
    })),
    MULTI_BLANK(new CustomSeparator((bytes, values2) -> {
        int mark = 0;
        int length = bytes.length();
        for (int start = 0; start < length; ++start) {
            if (bytes.fastByteAt(start) != 32 && bytes.fastByteAt(start) != 9) continue;
            if (mark != start) {
                values2.add(bytes.subBytes(mark, start));
            }
            mark = start + 1;
        }
        values2.add(bytes.subBytes(mark));
    })),
    TAB(new CustomSeparator(9)),
    COMMA(new CustomSeparator(44)),
    SEMICOLON(new CustomSeparator(59)),
    UNIVERSAL(new CustomSeparator(9, 32, 44, 59)),
    BDD(new CustomSeparator((lineCache, values2) -> {
        int mark = 0;
        boolean quotation = false;
        if (lineCache.length() == 0) {
            return;
        }
        for (int i = 0; i < lineCache.length(); ++i) {
            if (lineCache.fastByteAt(i) == 34) {
                boolean bl = quotation = !quotation;
            }
            if (quotation || lineCache.fastByteAt(i) != 32 && lineCache.fastByteAt(i) != 9) continue;
            if (lineCache.fastByteAt(mark) == 34) {
                values2.add(lineCache.subBytes(mark + 1, i - 1));
            } else {
                values2.add(lineCache.subBytes(mark, i));
            }
            mark = i + 1;
        }
        if (lineCache.length() == mark) {
            values2.add(lineCache.subBytes(mark));
        } else if (lineCache.length() != mark + 1 && lineCache.fastByteAt(mark) == 34 && lineCache.fastLastByteAt(0) == 34) {
            values2.add(lineCache.subBytes(mark + 1, lineCache.length() - 1));
        } else {
            values2.add(lineCache.subBytes(mark));
        }
    })),
    CDD(new CustomSeparator((lineCache, values2) -> {
        int mark = 0;
        boolean quotation = false;
        if (lineCache.length() == 0) {
            return;
        }
        for (int i = 0; i < lineCache.length(); ++i) {
            if (lineCache.fastByteAt(i) == 34) {
                boolean bl = quotation = !quotation;
            }
            if (quotation || lineCache.fastByteAt(i) != 44) continue;
            if (lineCache.fastByteAt(mark) == 34) {
                values2.add(lineCache.subBytes(mark + 1, i - 1));
            } else {
                values2.add(lineCache.subBytes(mark, i));
            }
            mark = i + 1;
        }
        if (lineCache.length() == mark) {
            values2.add(lineCache.subBytes(mark));
        } else if (lineCache.fastByteAt(mark) == 34 && lineCache.fastLastByteAt(0) == 34) {
            values2.add(lineCache.subBytes(mark + 1, lineCache.length() - 1));
        } else {
            values2.add(lineCache.subBytes(mark));
        }
    })),
    SDD(new CustomSeparator((lineCache, values2) -> {
        int mark = 0;
        boolean quotation = false;
        if (lineCache.length() == 0) {
            return;
        }
        for (int i = 0; i < lineCache.length(); ++i) {
            if (lineCache.fastByteAt(i) == 34) {
                boolean bl = quotation = !quotation;
            }
            if (quotation || lineCache.fastByteAt(i) != 59) continue;
            if (lineCache.fastByteAt(mark) == 34) {
                values2.add(lineCache.subBytes(mark + 1, i - 1));
            } else {
                values2.add(lineCache.subBytes(mark, i));
            }
            mark = i + 1;
        }
        if (lineCache.length() == mark) {
            values2.add(lineCache.subBytes(mark));
        } else if (lineCache.fastByteAt(mark) == 34 && lineCache.fastLastByteAt(0) == 34) {
            values2.add(lineCache.subBytes(mark + 1, lineCache.length() - 1));
        } else {
            values2.add(lineCache.subBytes(mark));
        }
    })),
    NONE(new CustomSeparator((lineCache, values2) -> values2.add(lineCache)));

    final ISeparator separator;

    private Separator(CustomSeparator separator) {
        this.separator = separator;
    }

    @Override
    public void accept(Bytes lineCache, List<Bytes> values2) {
        this.separator.accept(lineCache, values2);
    }
}

