/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.text.reader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.partreader.IPartReader;
import edu.sysu.pmglab.io.partreader.NoPartReader;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.io.text.reader.Separator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class TextReader
implements AutoCloseable,
Closeable {
    final LiveFile file;
    final ReaderStream reader;
    final ByteStream cache;
    final List<Bytes> values = new List(16);
    final ICCFMeta metas;
    final ISeparator separator;
    final TextRecord record;
    final ReentrantLock LOCK = new ReentrantLock();
    final AtomicLong pointer = new AtomicLong(-1L);
    final Bytes wrapper = new Bytes();
    final boolean share;

    private TextReader(LiveFile file, ReaderStream reader, ByteStream cache, IndexableSet<String> fields, ISeparator separator, ICCFMeta metas, long initPointer, boolean share) {
        this.file = file;
        this.reader = reader;
        this.cache = cache;
        this.record = new TextRecord(fields);
        this.separator = separator;
        this.metas = metas;
        this.pointer.set(initPointer);
        this.share = share;
    }

    public static Builder setInput(String path) throws IOException {
        return new Builder(LiveFile.of(path));
    }

    public static Builder setInput(File path) throws IOException {
        return new Builder(LiveFile.of(path));
    }

    public static Builder setInput(LiveFile path) {
        return new Builder(path);
    }

    public TextRecord read() throws IOException {
        if (this.share) {
            if (this.read(this.record)) {
                return this.record;
            }
        } else {
            TextRecord record = new TextRecord(this.getHeader());
            if (this.read(record)) {
                return record;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(TextRecord results) throws IOException {
        this.LOCK.lock();
        try {
            int i;
            if (this.cache.length() == 0 && this.reader.readline(this.cache) == -1) {
                boolean bl = false;
                return bl;
            }
            this.values.clear();
            this.cache.toBytes(this.wrapper);
            this.separator.accept(this.wrapper, this.values);
            if (this.values.size() != this.record.size()) {
                if (this.pointer.get() != -1L) {
                    throw new IOException("The data row " + this.pointer.get() + " contains " + this.values.size() + " field values, while the header specifies " + this.record.size() + " fields: \n" + this.cache.toBytes());
                }
                throw new IOException("The row contains " + this.values.size() + " field values, while the header specifies " + this.record.size() + " fields: \n" + this.cache.toBytes());
            }
            if (results == this.record || results.keys() == this.record.keys()) {
                if (this.share) {
                    int l = results.size();
                    for (i = 0; i < l; ++i) {
                        results.set(i, this.values.fastGet(i));
                    }
                } else {
                    int l = results.size();
                    for (i = 0; i < l; ++i) {
                        results.set(i, this.values.fastGet(i).detach());
                    }
                }
            } else if (this.share) {
                int l = results.size();
                for (i = 0; i < l; ++i) {
                    String field = results.keyOf(i);
                    int index = this.record.indexOf(field);
                    if (index != -1) {
                        results.set(i, this.values.fastGet(index));
                        continue;
                    }
                    results.set(i, (Bytes)null);
                }
            } else {
                int l = results.size();
                for (i = 0; i < l; ++i) {
                    String field = results.keyOf(i);
                    int index = this.record.indexOf(field);
                    if (index != -1) {
                        results.set(i, this.values.fastGet(index).detach());
                        continue;
                    }
                    results.set(i, (Bytes)null);
                }
            }
            this.cache.clear();
            this.values.clear();
            this.wrapper.reset(Bytes.EMPTY);
            if (this.pointer.get() != -1L) {
                this.pointer.getAndAdd(1L);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.LOCK.unlock();
        }
    }

    public ICCFMeta getMeta() {
        return this.metas;
    }

    public LiveFile getFile() {
        return this.file;
    }

    public TextRecord getRecord() {
        return this.record;
    }

    public IndexableSet<String> getHeader() {
        return this.record.keys();
    }

    public long tell() {
        return this.pointer.get();
    }

    @Override
    public void close() throws IOException {
        this.LOCK.lock();
        try {
            this.reader.close();
            this.cache.close();
        }
        finally {
            this.LOCK.unlock();
        }
    }

    public boolean containsField(String field) {
        return this.record.containsKey(field);
    }

    public static class Builder {
        final LiveFile path;
        protected IMetadataParser metadataParser = IMetadataParser.BEGIN_WITH_2_NUMBER_SIGN;
        protected IHeaderParser headerParser = IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN;
        protected ISeparator separator = Separator.TAB;
        protected boolean share = true;

        private Builder(LiveFile path) {
            this.path = path;
        }

        public TextReader instance() throws IOException {
            return this.instance(1).get(0);
        }

        public List<TextReader> instance(int nParts) throws IOException {
            IPartReader reader = (nParts = Math.max(1, nParts)) == 1 ? new NoPartReader(this.path) : IPartReader.instanceOf(this.path);
            ICCFMeta metas = new CCFMeta();
            ByteStream cache = new ByteStream(1024);
            LinkedSet<String> header = new LinkedSet();
            Bytes wrapper = new Bytes();
            long lineIndex = 0L;
            while (reader.readline(cache) != -1) {
                cache.toBytes(wrapper);
                if (!this.metadataParser.parse(lineIndex++, wrapper, metas)) {
                    if (this.headerParser.parse(wrapper, this.separator, header)) {
                        cache.clear();
                        reader.readline(cache);
                        break;
                    }
                    if (((AbstractCollection)header).size() != 0) break;
                    int number = this.separator.accept(wrapper).size();
                    for (int i = 0; i < number; ++i) {
                        ((AbstractCollection)header).add("V" + (i + 1));
                    }
                    break;
                }
                cache.clear();
            }
            wrapper.reset(Bytes.EMPTY);
            metas = metas.asUnmodifiable();
            header = header.asUnmodifiable();
            List<ReaderStream> readers = reader.part(nParts);
            List<TextReader> returns = new List<TextReader>(readers.size());
            returns.add(new TextReader(this.path, readers.popFirst(), cache, header, this.separator, metas, nParts == 1 ? 0L : -1L, this.share));
            while (readers.size() > 0) {
                returns.add(new TextReader(this.path, readers.popFirst(), new ByteStream(1024), header, this.separator, metas, nParts == 1 ? 0L : -1L, this.share));
            }
            return returns.asUnmodifiable();
        }

        public LiveFile getFile() {
            return this.path;
        }

        public Builder share(boolean share) {
            this.share = share;
            return this;
        }

        public ISeparator getSeparator() {
            return this.separator;
        }

        public Builder setSeparator(ISeparator separator) {
            this.separator = separator == null ? Separator.TAB : separator;
            return this;
        }

        public IHeaderParser getHeaderParser() {
            return this.headerParser;
        }

        public Builder setHeaderParser(IHeaderParser headerParser) {
            this.headerParser = headerParser == null ? IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN : headerParser;
            return this;
        }

        public IMetadataParser getMetadataParser() {
            return this.metadataParser;
        }

        public Builder setMetadataParser(IMetadataParser metadataParser) {
            this.metadataParser = metadataParser == null ? IMetadataParser.BEGIN_WITH_2_NUMBER_SIGN : metadataParser;
            return this;
        }
    }
}

