/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.text.writer;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.writer.IJoiner;
import java.io.IOException;
import java.io.OutputStream;

public class CustomJoiner
implements IJoiner {
    final IJoiner consumer;

    public CustomJoiner(final String format) {
        if (format == null) {
            throw new IllegalArgumentException("Invalid format string");
        }
        Bytes rule = new Bytes(format);
        final List<Bytes> keywords = new List<Bytes>();
        int index = 0;
        int offset = 0;
        while (index < rule.length()) {
            if (rule.fastByteAt(index) == 123 && index < rule.length() - 1 && rule.fastByteAt(index + 1) == 125) {
                if (index != offset) {
                    keywords.add(rule.subBytes(offset, index));
                }
                offset = index += 2;
                if (keywords.size() >= 1 && keywords.fastLastGet(0) == null) {
                    throw new IllegalArgumentException("Ambiguous format: adjacent placeholders without separators");
                }
                keywords.add(null);
                continue;
            }
            ++index;
        }
        if (index != offset) {
            keywords.add(rule.subBytes(offset, index));
        }
        this.consumer = new IJoiner(){

            @Override
            public Bytes accept(List<Bytes> values2) {
                ByteStream container = new ByteStream();
                try {
                    int targetIndex = 0;
                    for (int i = 0; i < keywords.size(); ++i) {
                        Bytes keyword = (Bytes)keywords.fastGet(i);
                        if (keyword == null) {
                            container.write(values2.get(targetIndex++));
                            continue;
                        }
                        container.write(keyword);
                    }
                    if (targetIndex != values2.size()) {
                        throw new IllegalArgumentException("Input does not match the format: " + format);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Input does not match the format: " + format);
                }
                return container.toBytes();
            }

            @Override
            public void accept(List<Bytes> values2, OutputStream output) throws IOException {
                try {
                    int targetIndex = 0;
                    for (int i = 0; i < keywords.size(); ++i) {
                        Bytes keyword = (Bytes)keywords.fastGet(i);
                        if (keyword == null) {
                            Bytes value = values2.get(targetIndex++);
                            output.write(value.bytes(), value.offset(), value.length());
                            continue;
                        }
                        output.write(keyword.bytes(), keyword.offset(), keyword.length());
                    }
                    if (targetIndex != values2.size()) {
                        throw new IllegalArgumentException("Input does not match the format: " + format);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Input does not match the format: " + format);
                }
            }
        };
    }

    public CustomJoiner(final byte separator, final boolean quotation) {
        this.consumer = new IJoiner(){

            @Override
            public Bytes accept(List<Bytes> values2) {
                ByteStream container = new ByteStream();
                int l = values2.size();
                for (int i = 0; i < l; ++i) {
                    Bytes value;
                    if (i > 0) {
                        container.write(separator);
                    }
                    if ((value = values2.fastGet(i)) == null) continue;
                    if (quotation && value.indexOf(separator) != -1) {
                        container.write(34);
                        container.write(value);
                        container.write(34);
                        continue;
                    }
                    container.write(value);
                }
                return container.toBytes();
            }

            @Override
            public void accept(List<Bytes> values2, OutputStream output) throws IOException {
                int l = values2.size();
                for (int i = 0; i < l; ++i) {
                    Bytes value;
                    if (i > 0) {
                        output.write(separator);
                    }
                    if ((value = values2.fastGet(i)) == null) continue;
                    if (quotation && value.indexOf(separator) != -1) {
                        output.write(34);
                        output.write(value.bytes(), value.offset(), value.length());
                        output.write(34);
                        continue;
                    }
                    output.write(value.bytes(), value.offset(), value.length());
                }
            }
        };
    }

    @Override
    public Bytes accept(List<Bytes> values2) {
        return this.consumer.accept(values2);
    }

    @Override
    public void accept(List<Bytes> values2, OutputStream output) throws IOException {
        this.consumer.accept(values2, output);
    }

    @Override
    public Bytes accept(Bytes ... values2) {
        return this.consumer.accept(values2);
    }
}

