/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.text.writer;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.IOException;

public interface IMetadataFormatter {
    public static final IMetadataFormatter BEGIN_WITH_1_NUMBER_SIGN = IMetadataFormatter.beginWith("#");
    public static final IMetadataFormatter BEGIN_WITH_2_NUMBER_SIGN = IMetadataFormatter.beginWith("##");
    public static final IMetadataFormatter NO_METADATA = (metas, container) -> false;

    public static IMetadataFormatter beginWith(String prefix) {
        Bytes marker = prefix == null || prefix.length() == 0 ? Bytes.EMPTY : new Bytes(prefix);
        return (metas, container) -> {
            boolean empty = true;
            for (CCFMetaItem item : metas.filter(meta -> !meta.getKey().startsWith("$"))) {
                if (!empty) {
                    container.write(10);
                }
                empty = false;
                container.write(marker);
                container.writeChar(item.toString());
            }
            return !empty;
        };
    }

    public boolean format(CCFMeta var1, IWriterStream var2) throws IOException;
}

