/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.text.writer;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.bgzip.BGZIPConstants;
import edu.sysu.pmglab.io.bgzip.pbgzip.IBGZIPWriterStream;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.partreader.BoundReader;
import edu.sysu.pmglab.io.reader.IReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.writer.IHeaderFormatter;
import edu.sysu.pmglab.io.text.writer.IJoiner;
import edu.sysu.pmglab.io.text.writer.IMetadataFormatter;
import edu.sysu.pmglab.io.text.writer.Joiner;
import edu.sysu.pmglab.io.writer.ChannelAppendStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import edu.sysu.pmglab.io.writer.StdoutStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import edu.sysu.pmglab.pconsumer.PBGZIPBlockEncoder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystemException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class TextWriter
implements AutoCloseable,
Closeable {
    final File tempDir;
    final File file;
    final IJoiner joiner;
    final AtomicBoolean closed = new AtomicBoolean(false);
    final IndexableSet<String> fields;
    final PBGZIPBlockEncoder encoder;
    final PartWriter[] writers;

    private TextWriter(IWriterStream writer, File file, int nParts, IndexableSet<String> fields, IJoiner joiner, PBGZIPBlockEncoder encoder) throws IOException {
        this.file = file;
        this.joiner = joiner;
        this.tempDir = nParts > 1 ? RuntimeProperty.createTempDir() : null;
        this.fields = fields;
        this.encoder = encoder;
        this.writers = new PartWriter[nParts];
        this.writers[0] = new PartWriter(writer, joiner, this.fields, file);
    }

    public static Builder stdout() {
        return new Builder();
    }

    public static Builder setOutput(String file) {
        return new Builder(file);
    }

    public static Builder setOutput(File file) {
        return new Builder(file);
    }

    public void finish(int partIndex) throws IOException {
        if (this.writers[partIndex] != null) {
            this.writers[partIndex].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextWriter write(int partIndex, TextRecord source2) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException("IO Stream closed");
        }
        if (source2 == null) {
            return this;
        }
        if (this.writers[partIndex] == null) {
            TextWriter textWriter = this;
            synchronized (textWriter) {
                if (this.writers[partIndex] == null) {
                    if (this.encoder == null) {
                        File temp = new File(this.tempDir, "part_" + (partIndex + 1));
                        temp.deleteOnExit();
                        this.writers[partIndex] = new PartWriter(new WriterStream(temp, WriterStream.Option.DEFAULT), this.joiner, this.fields, temp);
                    } else {
                        File temp = new File(this.tempDir, "part_" + (partIndex + 1) + ".gz");
                        temp.deleteOnExit();
                        this.writers[partIndex] = new PartWriter(IBGZIPWriterStream.instanceOf(temp, this.encoder), this.joiner, this.fields, temp);
                    }
                }
            }
        }
        this.writers[partIndex].write(source2);
        return this;
    }

    public TextWriter write(TextRecord source2) throws IOException {
        return this.write(0, source2);
    }

    public File getFile() {
        return this.file;
    }

    public int numOfParts() {
        return this.writers.length;
    }

    public TextRecord getRecord() {
        return new TextRecord(this.fields);
    }

    public IndexableSet<String> keys() {
        return this.fields;
    }

    public long numOfRecords() {
        long count = 0L;
        for (PartWriter writer : this.writers) {
            if (writer == null) continue;
            count += writer.numOfRecords();
        }
        return count;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        for (int i = 0; i < this.writers.length; ++i) {
            this.finish(i);
        }
        if (this.encoder != null) {
            this.encoder.stop();
        }
        if (this.writers.length > 1) {
            ChannelAppendStream output = new ChannelAppendStream(this.file);
            if (this.encoder != null) {
                output.seek(output.tell() - (long)BGZIPConstants.EMPTY_BGZIP_BLOCK.length);
                for (int i = 1; i < this.writers.length; ++i) {
                    if (this.writers[i] == null) continue;
                    File file = this.writers[i].getFile();
                    if (this.writers[i].numOfRecords() > 0L) {
                        BoundReader reader = new BoundReader(LiveFile.of(file).openAsBinary(), new LongInterval(0L, file.length() - (long)BGZIPConstants.EMPTY_BGZIP_BLOCK.length));
                        reader.transferTo(0L, ((ISeekableReaderStream)reader).length(), output);
                        ((IReaderStream)reader).close();
                    }
                    FileUtils.delete(file);
                }
                output.write(BGZIPConstants.EMPTY_BGZIP_BLOCK);
            } else {
                for (int i = 1; i < this.writers.length; ++i) {
                    if (this.writers[i] == null) continue;
                    File file = this.writers[i].getFile();
                    if (this.writers[i].numOfRecords() > 0L) {
                        ISeekableReaderStream reader = LiveFile.of(file).openAsBinary();
                        reader.transferTo(0L, reader.length(), output);
                        reader.close();
                    }
                    FileUtils.delete(file);
                }
            }
            output.close();
            FileUtils.delete(this.tempDir);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    static class PartWriter
    implements AutoCloseable,
    Closeable {
        final IWriterStream writer;
        final IJoiner joiner;
        final Bytes[] values;
        final AtomicLong counter = new AtomicLong(0L);
        final AtomicBoolean closed = new AtomicBoolean(false);
        final IndexableSet<String> fields;
        final File file;

        public PartWriter(IWriterStream writer, IJoiner joiner, IndexableSet<String> fields, File file) {
            this.writer = writer;
            this.joiner = joiner;
            this.values = new Bytes[fields.size()];
            this.fields = fields;
            this.file = file;
        }

        public PartWriter write(TextRecord source2) throws IOException {
            try {
                if (this.closed.get()) {
                    throw new IllegalStateException("Partial IO Stream closed");
                }
                int count = source2.size();
                int l = this.fields.size();
                for (int i = 0; i < l; ++i) {
                    Bytes value;
                    if (count == 0) {
                        this.values[i] = Bytes.EMPTY;
                        continue;
                    }
                    String field = this.fields.valueOf(i);
                    int sourceIndex = source2.indexOf(field);
                    if (sourceIndex != -1) {
                        value = source2.get(sourceIndex);
                        --count;
                    } else {
                        value = null;
                    }
                    this.values[sourceIndex] = value == null ? Bytes.EMPTY : value;
                }
                this.joiner.accept(this.values, (OutputStream)this.writer);
                this.writer.write(10);
            }
            catch (Error | Exception e) {
                throw new IOException(e);
            }
            finally {
                this.counter.addAndGet(1L);
            }
            return this;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed.get()) {
                this.closed.set(true);
                this.writer.close();
                Arrays.fill(this.values, null);
            }
        }

        public long numOfRecords() {
            return this.counter.get();
        }

        public File getFile() {
            return this.file;
        }
    }

    public static class Builder {
        final File path;
        final IndexableSet<String> fields = new LinkedSet<String>();
        final CCFMeta meta = new CCFMeta();
        IMetadataFormatter metadataFormatter = IMetadataFormatter.BEGIN_WITH_2_NUMBER_SIGN;
        IHeaderFormatter headerFormatter = IHeaderFormatter.BEGIN_WITH_1_NUMBER_SIGN;
        IJoiner valueJoiner = Joiner.TAB;
        int compressorLevel;

        private Builder() {
            this.path = null;
            this.compressorLevel = -2;
        }

        private Builder(String path) {
            if (path == null) {
                this.path = null;
                this.compressorLevel = -2;
            } else {
                this.path = new File(path);
                this.compressorLevel = FileUtils.withExtension(path, ".gz", ".bgz") ? 5 : -2;
            }
        }

        private Builder(File path) {
            if (path == null) {
                this.path = null;
                this.compressorLevel = -2;
            } else {
                this.path = path;
                this.compressorLevel = FileUtils.withExtension(path, ".gz", ".bgz") ? 5 : -2;
            }
        }

        public Builder setCompressionLevel(int level) {
            this.compressorLevel = level == -2 ? -2 : BGZIPConstants.checkCompressionLevel(level);
            return this;
        }

        public int getCompressorLevel() {
            return this.compressorLevel;
        }

        public boolean isCompressionEnabled() {
            return this.compressorLevel != -2;
        }

        public Builder addField(String field) {
            this.fields.add(field);
            return this;
        }

        public Builder addFields(String ... fields) {
            this.fields.addAll((String[])fields);
            return this;
        }

        public Builder addFields(Iterable<String> fields) {
            for (String field : fields) {
                this.fields.add(field);
            }
            return this;
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        public boolean containsField(String field) {
            return this.fields.contains(field);
        }

        public int numOfFields() {
            return this.fields.size();
        }

        public Builder addMeta(CCFMetaItem meta) {
            this.meta.add(meta);
            return this;
        }

        public Builder addMeta(String key) {
            this.meta.add(key);
            return this;
        }

        public Builder addMeta(String key, String value) {
            this.meta.add(key, value);
            return this;
        }

        public Builder addMeta(Iterable<CCFMetaItem> metas) {
            this.meta.adds(metas);
            return this;
        }

        public Builder clearMetas() {
            this.meta.clear();
            return this;
        }

        public Builder dropDuplicateMetas() {
            this.meta.dropDuplicates();
            return this;
        }

        public TextWriter instance() throws IOException {
            return this.instance(1);
        }

        public TextWriter instance(int nParts) throws IOException {
            PBGZIPBlockEncoder encoder;
            IWriterStream writer;
            nParts = this.path == null ? 1 : Math.max(1, nParts);
            IndexableSet fields = new LinkedSet<String>(this.fields).asUnmodifiable();
            if (this.path != null && this.path.exists()) {
                FileUtils.deleteFile(this.path);
                if (this.path.exists()) {
                    throw new FileSystemException("Readonly file stream: " + this.path);
                }
            }
            if (this.compressorLevel == -2) {
                writer = this.path == null ? new StdoutStream() : new WriterStream(this.path, WriterStream.Option.DEFAULT);
                encoder = null;
            } else if (this.path == null) {
                writer = IBGZIPWriterStream.instanceOf(new StdoutStream(), this.compressorLevel, nParts);
                encoder = null;
            } else if (nParts == 1) {
                writer = IBGZIPWriterStream.instanceOf(this.path, this.compressorLevel, nParts);
                encoder = null;
            } else {
                encoder = (PBGZIPBlockEncoder)new PBGZIPBlockEncoder(this.compressorLevel, nParts).start();
                writer = IBGZIPWriterStream.instanceOf(this.path, encoder);
            }
            if (this.meta.size() > 0 && this.metadataFormatter.format(this.meta, writer)) {
                writer.write(10);
            }
            if (this.headerFormatter.format(this.fields, this.valueJoiner, writer)) {
                writer.write(10);
            }
            return new TextWriter(writer, this.path, nParts, fields, this.valueJoiner, encoder);
        }

        public File getFile() {
            return this.path;
        }

        public IJoiner getValueJoiner() {
            return this.valueJoiner;
        }

        public Builder setValueJoiner(IJoiner valueJoiner) {
            this.valueJoiner = this.headerFormatter == null ? Joiner.TAB : valueJoiner;
            return this;
        }

        public IHeaderFormatter getHeaderFormatter() {
            return this.headerFormatter;
        }

        public Builder setHeaderFormatter(IHeaderFormatter headerFormatter) {
            this.headerFormatter = headerFormatter == null ? IHeaderFormatter.BEGIN_WITH_1_NUMBER_SIGN : headerFormatter;
            return this;
        }

        public IMetadataFormatter getMetadataFormatter() {
            return this.metadataFormatter;
        }

        public Builder setMetadataFormatter(IMetadataFormatter metadataParser) {
            this.metadataFormatter = metadataParser == null ? IMetadataFormatter.BEGIN_WITH_2_NUMBER_SIGN : metadataParser;
            return this;
        }

        public IndexableSet<String> getAllFields() {
            return this.fields.asUnmodifiable();
        }

        public ICCFMeta getMeta() {
            return this.meta.asUnmodifiable();
        }
    }
}

