/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.writer;

import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class ChannelOutputStream
extends IWriterStream {
    final File file;
    final FileChannel writer;
    final ByteBuffer buffer = ByteBuffer.allocateDirect(8192);

    public ChannelOutputStream(File file, FileChannel channel) {
        this.file = file;
        this.writer = channel;
    }

    @Override
    public final void write(byte[] src, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        while (len > 0) {
            if (this.buffer.position() == 0 && len >= this.buffer.capacity()) {
                this.writer.write(ByteBuffer.wrap(src, off, len));
                off += len;
                len -= len;
                break;
            }
            int bytesToWrite = Math.min(len, this.buffer.remaining());
            this.buffer.put(src, off, bytesToWrite);
            off += bytesToWrite;
            len -= bytesToWrite;
            if (this.buffer.position() != this.buffer.capacity()) continue;
            this.flush();
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this.buffer.position() > 0) {
            this.buffer.flip();
            this.writer.write(this.buffer);
            this.buffer.clear();
        }
    }

    @Override
    public final void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    public final File getFile() {
        return this.file;
    }

    public final FileChannel getFileChannel() {
        return this.writer;
    }

    public final ChannelOutputStream seek(long pointer) throws IOException {
        this.writer.position(pointer);
        return this;
    }

    public final long tell() throws IOException {
        return this.writer.position();
    }
}

