/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.writer;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.DockerCopyer;
import java.io.File;
import java.io.IOException;

public final class DockerWriterStream
extends IWriterStream {
    final File tempFile;
    final DockerCopyer copyer;
    final String containerPath;
    final ChannelWriterStream writer;

    public DockerWriterStream(String containerID, String filePath) throws IOException {
        this(new DockerCopyer(containerID), filePath);
    }

    public DockerWriterStream(DockerCopyer copyer, String filePath) throws IOException {
        Assert.that(copyer != null && filePath != null);
        this.tempFile = RuntimeProperty.createTempFile();
        this.writer = new ChannelWriterStream(this.tempFile);
        this.containerPath = filePath;
        this.copyer = copyer;
        this.tempFile.deleteOnExit();
    }

    public DockerWriterStream(String path) throws IOException {
        if (path == null || !path.contains(":")) {
            throw new IOException("must specify the container source: <containerID>:<path>");
        }
        String containerID = path.substring(0, path.indexOf(":"));
        this.copyer = new DockerCopyer(containerID);
        this.tempFile = RuntimeProperty.createTempFile();
        this.tempFile.deleteOnExit();
        this.writer = new ChannelWriterStream(this.tempFile);
        this.containerPath = path.substring(containerID.length() + 1);
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public DockerCopyer getDockerCopyer() {
        return this.copyer;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            this.writer.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
            this.copyer.send(this.tempFile.getCanonicalPath(), this.containerPath);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | Exception e) {
            throw new IOException(e);
        }
        finally {
            FileUtils.delete(this.tempFile);
        }
    }
}

