/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.writer;

import edu.sysu.pmglab.ccf.compressor.gzip.GZIPOutputStream;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public final class GZIPWriterStream
extends IWriterStream {
    final GZIPOutputStream writer;

    public GZIPWriterStream(File file, int compressionLevel) throws IOException {
        this(new ChannelWriterStream(file), compressionLevel);
    }

    public GZIPWriterStream(File file) throws IOException {
        this(file, 5);
    }

    public GZIPWriterStream(OutputStream output) throws IOException {
        this(output, 5);
    }

    public GZIPWriterStream(OutputStream output, int compressionLevel) throws IOException {
        this.writer = new GZIPOutputStream(output, compressionLevel);
    }

    @Override
    public void write(byte[] src, int offset, int length) throws IOException {
        this.writer.write(src, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

