/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.writer;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;

public abstract class IWriterStream
extends OutputStream {
    ByteStream CACHE;

    @Override
    public void write(int b) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.write(b);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public final void write(Bytes buffer) throws IOException {
        this.write(buffer.bytes(), buffer.offset(), buffer.length());
    }

    public final void writeChar(boolean value) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.writeChar(value);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeChar(int value) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.writeChar(value);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeChar(long value) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.writeChar(value);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeChar(double value) throws IOException {
        this.writeChar(value, null);
    }

    public final void writeChar(double value, DecimalFormat formatter) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.writeChar(value, formatter);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeChar(String src) throws IOException {
        this.writeChar(src, StandardCharsets.UTF_8);
    }

    public final void writeChar(String src, Charset charset) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.writeChar(src, charset);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeShort(short value) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.putShort(value);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeInt(int value) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.putInt(value);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeVarInt(int value) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.putVarInt32(value);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeVarInt(long value) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.putVarInt64(value);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeLong(long value) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.putLong(value);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }

    public final void writeLong(long value, int length) throws IOException {
        if (this.CACHE == null) {
            this.CACHE = new ByteStream(32);
        }
        this.CACHE.clear();
        this.CACHE.putLong(value, length);
        this.write(this.CACHE.bytes(), this.CACHE.offset(), this.CACHE.length());
        this.CACHE.clear();
    }
}

