/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.writer;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import edu.sysu.pmglab.io.file.SFTPFile;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.IOException;
import java.io.OutputStream;

public final class SFTPWriterStream
extends IWriterStream {
    private final SFTPFile.Path file;
    private final ChannelSftp sftpChannel;
    private final Session session;
    private final OutputStream writer;

    public SFTPWriterStream(SFTPFile.Path file) throws IOException {
        try {
            this.file = file;
            JSch jsch = new JSch();
            this.session = jsch.getSession(this.file.username, this.file.host, this.file.port);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.setPassword(this.file.password);
            this.session.connect();
            this.sftpChannel = (ChannelSftp)this.session.openChannel("sftp");
            this.sftpChannel.connect();
            this.writer = this.sftpChannel.put(this.file.remotePath);
        }
        catch (JSchException | SftpException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            this.writer.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.sftpChannel.disconnect();
        this.session.disconnect();
    }

    public SFTPFile.Path getFile() {
        return this.file;
    }
}

