/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.writer;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.IOException;

public final class StdoutStream
extends IWriterStream {
    private final ByteStream cache = new ByteStream(16384, false);

    @Override
    public void write(byte[] src, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        while (len > 0) {
            int byteToWrite = Math.min(this.cache.wRemaining(), len);
            this.cache.write(src, off, byteToWrite);
            off += byteToWrite;
            len -= byteToWrite;
            if (this.cache.wRemaining() != 0) continue;
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.cache.length() > 0) {
            System.out.print(new String(this.cache.bytes(), this.cache.offset(), this.cache.length()));
            this.cache.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.cache.close();
    }
}

