/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.writer;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.io.bgzip.pbgzip.IBGZIPWriterStream;
import edu.sysu.pmglab.io.writer.ChannelAppendStream;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.io.writer.GZIPWriterStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.File;
import java.io.IOException;

public final class WriterStream
extends IWriterStream {
    final IWriterStream writer;
    final ByteStream cache = new ByteStream(16384, false);

    public WriterStream(File address, Option mode) throws IOException {
        switch (mode) {
            case DEFAULT: {
                this.writer = new ChannelWriterStream(address);
                break;
            }
            case APPEND: {
                this.writer = new ChannelAppendStream(address);
                break;
            }
            case BGZIP: {
                this.writer = IBGZIPWriterStream.instanceOf(address, 5, 2);
                break;
            }
            case GZIP: {
                this.writer = new GZIPWriterStream(address);
                break;
            }
            case SFTP: 
            case SFTP_GZIP: 
            case SFTP_BGZIP: {
                throw new IOException("When writing data to the sftp-url, java.io.File instance cannot be used as input");
            }
            case DOCKER: 
            case DOCKER_GZIP: 
            case DOCKER_BGZIP: {
                throw new IOException("When writing data to the docker container, java.io.File instance cannot be used as input");
            }
            default: {
                throw new IOException();
            }
        }
    }

    public WriterStream(IWriterStream writer) {
        this.writer = writer;
    }

    @Override
    public void write(byte[] src, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        while (len > 0) {
            if (this.cache.length() == 0 && len >= this.cache.capacity()) {
                this.writer.write(src, off, len);
                off += len;
                len -= len;
                break;
            }
            int byteToWrite = Math.min(this.cache.wRemaining(), len);
            this.cache.write(src, off, byteToWrite);
            off += byteToWrite;
            len -= byteToWrite;
            if (this.cache.wRemaining() != 0) continue;
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.cache.length() > 0) {
            this.writer.write(this.cache.bytes(), this.cache.offset(), this.cache.length());
            this.cache.clear();
        }
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
        this.cache.close();
    }

    public IWriterStream getWriterStream() {
        return this.writer;
    }

    public static enum Option {
        DEFAULT,
        APPEND,
        BGZIP,
        GZIP,
        SFTP,
        SFTP_GZIP,
        SFTP_BGZIP,
        DOCKER,
        DOCKER_BGZIP,
        DOCKER_GZIP;

    }
}

