/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga;

import edu.sysu.pmglab.analysis.GenomeRegion;
import edu.sysu.pmglab.annotation.Var2RegionMapper;
import edu.sysu.pmglab.ccf.filter.FoundAction;
import edu.sysu.pmglab.ccf.filter.NotFoundAction;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.LongList;
import edu.sysu.pmglab.container.rangelist.VarInt64RangeList;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.filter.GTBFilter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.RefGenomeVersion;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.TextReader;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.LDPruneOptions;
import edu.sysu.pmglab.kgga.command.pipeline.PreprocessingPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.command.task.LDPruningTask;
import edu.sysu.pmglab.kgga.command.task.OutputVariants2TSVTask;
import edu.sysu.pmglab.kgga.io.InputPhenotypeFileSet;
import edu.sysu.pmglab.kgga.io.InputType;
import edu.sysu.pmglab.stat.LogisticRegression;
import edu.sysu.pmglab.stat.Summary;
import gnu.trove.iterator.TLongIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;

public class Test {
    public static void main3(String[] args) {
    }

    public static void main1(String[] args) throws IOException {
        String inputPath = "/home/lmx/gpu/mxli/data/projects/ukb/test/variants.hg38.tsv.gz";
        TextReader reader = TextReader.setInput(inputPath).instance();
        String outputPath = "/home/lmx/gpu/mxli/data/projects/ukb/test/variants.hg38.tsv.txt";
        File writeName = new File(outputPath);
        List<String> names = new List<String>(reader.getHeader());
        writeName.createNewFile();
        int colNum = names.size();
        try (FileWriter writer = new FileWriter(writeName);
             BufferedWriter out = new BufferedWriter(writer);){
            TextRecord record;
            int i;
            out.write(names.get(0));
            for (i = 1; i < colNum; ++i) {
                out.write(9);
                out.write(names.get(i));
            }
            out.write(10);
            while ((record = reader.read()) != null) {
                String chrom = record.get("CHROM").toString();
                if (chrom.equals("X")) continue;
                int count = record.get("GTYSUM@AltHomGtyNum_ALL").toInt();
                int count1 = record.get("GTYSUM@RefHomGtyNum_ALL").toInt();
                int count2 = record.get("GTYSUM@HetGtyNum_ALL").toInt();
                double af = 0.5 * (double)count2 + (double)count;
                af /= (double)(count + count1 + count2);
                if (count <= 10 || !(af > 0.01) || count1 <= count) continue;
                out.write(record.get(names.get(0)).toString());
                for (i = 1; i < colNum; ++i) {
                    out.write(9);
                    out.write(record.get(names.get(i)).toString());
                }
                out.write(10);
            }
        }
        reader.close();
    }

    public static void main2(String[] args) throws IOException {
    }

    public static List<Variant> getMapVariants(File file) throws IOException {
        Var2RegionMapper mapper = new Var2RegionMapper();
        GTBManager manager = new GTBManager(file);
        File geneAnnotationFile = FileUtils.getSubFile(file.getParentFile().getParentFile(), "/AssignVar2GeneTask/genes.annot.hg38.ccf");
        Map<String, GenomeRegion> geneRegionMap = mapper.readAssignedVarPointersOfGenes(geneAnnotationFile);
        List<GenomeRegion> geneRegions = new List<GenomeRegion>(geneRegionMap.values());
        geneRegions.sort(Comparator.comparingLong(GenomeRegion::getStartPointer).thenComparingLong(GenomeRegion::getEndPointer));
        LongList pointersAnnotFile = new LongList();
        int geneNum = geneRegions.size();
        GTBReader annotReader = new GTBReader(new GTBReaderOption(manager, false, true));
        List<Variant> variantsTmp = new List<Variant>();
        for (int i = 0; i < geneNum; ++i) {
            GenomeRegion gene = geneRegions.get(i);
            VarInt64RangeList pb = gene.getOutcomeVarPointers();
            if (pb == null) continue;
            TLongIterator pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                long pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            int size = pointersAnnotFile.size();
            variantsTmp.clear();
            for (int m = 0; m < size; ++m) {
                annotReader.seek(pointersAnnotFile.get(m));
                Variant annotVariant = annotReader.read();
                variantsTmp.add(annotVariant);
            }
            if (variantsTmp.size() <= 60) continue;
            return variantsTmp;
        }
        return null;
    }

    public static List<Variant> getTargetVariants(List<Variant> annotVars, String[] metas) {
        double num;
        LogisticRegression logisticRegression = new LogisticRegression();
        double[] coef = new double[metas.length + 1];
        coef[0] = Math.log(0.05);
        for (int i = 0; i < metas.length; ++i) {
            coef[i + 1] = Math.log(5.0);
        }
        logisticRegression.setCoef(coef);
        double[] y = new double[annotVars.size()];
        double[] mean = new double[metas.length];
        double[] sd = new double[metas.length];
        double[] tmp = new double[annotVars.size()];
        List<Variant> result = new List<Variant>();
        for (int j = 0; j < metas.length; ++j) {
            for (int i = 0; i < annotVars.size(); ++i) {
                num = ((Number)annotVars.get(i).getProperty(metas[j])).floatValue();
                tmp[i] = Double.isNaN(num) ? 0.0 : num;
            }
            mean[j] = Summary.mean(tmp);
            sd[j] = Summary.sd(tmp);
        }
        for (int i = 0; i < annotVars.size(); ++i) {
            Variant var = annotVars.get(i);
            double[] metaInfo = new double[metas.length + 1];
            metaInfo[0] = 1.0;
            for (int j = 0; j < metas.length; ++j) {
                num = ((Number)var.getProperty(metas[j])).doubleValue();
                num = Double.isNaN(num) ? 0.0 : num;
                metaInfo[j + 1] = (num - mean[j]) / sd[j];
            }
            y[i] = logisticRegression.getGivenProbability(metaInfo);
            if (!(y[i] > 0.5)) continue;
            result.add(var);
        }
        return result;
    }

    public static List<Variant> getSamePositionVariants(List<Variant> annotVars, List<Variant> gtyVars) {
        List<Variant> result = new List<Variant>();
        int i = 0;
        int j = 0;
        while (i < annotVars.size() && j < gtyVars.size()) {
            Variant annotVar = annotVars.get(i);
            Variant gtyVar = gtyVars.get(j);
            if (annotVar.getPosition() == gtyVar.getPosition()) {
                result.add(gtyVar);
                ++i;
                ++j;
                continue;
            }
            if (annotVar.getPosition() < gtyVar.getPosition()) {
                ++i;
                continue;
            }
            ++j;
        }
        return result;
    }

    public static List<Variant> getSamePositionVariantsAnno(List<Variant> annotVars, List<Variant> gtyVars) {
        List<Variant> result = new List<Variant>();
        int i = 0;
        int j = 0;
        while (i < annotVars.size() && j < gtyVars.size()) {
            Variant annotVar = annotVars.get(i);
            Variant gtyVar = gtyVars.get(j);
            if (annotVar.getPosition() == gtyVar.getPosition()) {
                result.add(annotVar);
                ++i;
                ++j;
                continue;
            }
            if (annotVar.getPosition() < gtyVar.getPosition()) {
                ++i;
                continue;
            }
            ++j;
        }
        return result;
    }

    public static double[] getCaseAndControlAlleleFreq(float groupPar, float OR, int size) {
        float par = groupPar / (float)size;
        float controlAf = 1.0f / ((OR - 1.0f) * (1.0f - par) / par);
        float caseAF = OR * controlAf / (1.0f + (OR - 1.0f) * controlAf);
        return new double[]{caseAF, controlAf};
    }

    public static int[] sampleAndSumGenotypes(int[][] genotypeCodes, int numColumnsToSample) {
        int numCols = genotypeCodes[0].length;
        Random random = new Random();
        int[] columnSums = new int[numColumnsToSample];
        for (int j = 0; j < numColumnsToSample; ++j) {
            int randomCol = random.nextInt(numCols);
            int randomRow = random.nextInt(2);
            columnSums[j] = genotypeCodes[randomRow][randomCol];
        }
        return columnSums;
    }

    public static void main(String[] args) throws IOException {
        GeneralIOOptions ioOptions = new GeneralIOOptions();
        VCFQualityControlOptions vcfQualityControlOptions = new VCFQualityControlOptions();
        try {
            ioOptions.inputGTYFiles.add(new VariantFileMeta("https://idc.biosino.org/pmglab/resource/kgg/kgga/example/assoc.hg19.vcf.gz", InputType.VCF, RefGenomeVersion.hg19));
            ioOptions.phenoFileSet = new InputPhenotypeFileSet("https://idc.biosino.org/pmglab/resource/kgg/kgga/example/assoc.ped");
            ioOptions.localMaf = new FloatInterval(0.05f, 0.5f);
            File workspace = new File("./test1");
            int threadNum = 4;
            Executor workflow = new Executor();
            Utility.addTrack(workflow, workspace);
            GTBManager annotationBasedGTB = PreprocessingPipeline.INSTANCE.generateAnnotationBase(ioOptions, vcfQualityControlOptions, workflow, workspace);
            workflow.execute();
            workflow.clearTasks();
            workflow.setParam("AnnotationBaseVariantSet", annotationBasedGTB.getFile());
            LDPruneOptions ldPruneOptions = new LDPruneOptions();
            ldPruneOptions.pruneR2 = 0.1f;
            workflow.addTask(new LDPruningTask(ldPruneOptions, null, workspace, true, threadNum));
            workflow.execute();
            workflow.clearTasks();
            workflow.addTask(new OutputVariants2TSVTask(workspace, threadNum));
            workflow.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main4(String[] args) throws IOException {
        Variant gtyVar;
        Var2RegionMapper mapper = new Var2RegionMapper();
        File annoteFile = new File("/Volumes/SSD/kggaTest/mcvs_WES_1218/AppendMutationSubjectIDTask/variants.annot.hg38.gtb");
        List<Variant> annotVars = Test.getMapVariants(annoteFile);
        String[] metas = new String[]{"conservation@CpG", "conservation@priPhCons", "conservationGeneFeature@verPhCons", "conservationGeneFeature@priPhyloP", "conservationGeneFeature@verPhyloP", "conservation::GerpN", "conservation::GC", "conservation::fitCons_all", "IntegrativeScore::cadd_phred", "IntegrativeScore::fathmm_xf", "conservation::GerpS"};
        Chromosome chr = annotVars.get(0).getChromosome();
        int start = annotVars.get(0).getPosition();
        int end = annotVars.get(annotVars.size() - 1).getPosition();
        List<Variant> targetVariants = Test.getTargetVariants(annotVars, metas);
        File gtyFile = new File("/Volumes/SSD/kggaTest/mcvs_WES_1218/GenerateAnnotationBaseTask0/variants.annot.gty.this.hg38.gtb");
        GTBManager gtyManager = new GTBManager(gtyFile);
        GTBReader gtyReader = new GTBReader(gtyManager);
        RefinedIntBuckets buckets = gtyManager.getIndexer().getTag(chr);
        gtyReader.limit(buckets.getRecordIndexRange());
        List<Variant> gtyVariants = new List<Variant>();
        while ((gtyVar = gtyReader.read()) != null) {
            if (gtyVar.getPosition() >= start && gtyVar.getPosition() <= end) {
                gtyVariants.add(gtyVar);
                continue;
            }
            if (gtyVar.getPosition() <= end) continue;
        }
        List<Variant> samePositionGTYVariants = Test.getSamePositionVariants(targetVariants, gtyVariants);
        List<Variant> samePositionAnnotVariants = Test.getSamePositionVariantsAnno(targetVariants, gtyVariants);
        int simulationIndividual = 10000;
        float par = 0.3f;
        float OR = 2.0f;
        double[] caseAndControlAlleleFreq = Test.getCaseAndControlAlleleFreq(par, OR, samePositionAnnotVariants.size());
        double[][] genotypes = new double[simulationIndividual][samePositionGTYVariants.size()];
        double[] genoX = new double[simulationIndividual];
        int caseNum = 0;
        int controlNum = 0;
        double caseAF = caseAndControlAlleleFreq[0];
        double controlAF = caseAndControlAlleleFreq[1];
        Random random = new Random(42L);
        for (int i = 0; i < simulationIndividual; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (i < simulationIndividual / 2) {
                    if (!(random.nextDouble() < caseAF)) continue;
                    int n = i;
                    genoX[n] = genoX[n] + 1.0;
                    ++caseNum;
                    continue;
                }
                if (!(random.nextDouble() < controlAF)) continue;
                int n = i;
                genoX[n] = genoX[n] + 1.0;
                ++controlNum;
            }
        }
        System.out.println(caseNum + "__" + controlNum);
    }

    public static void main0(String[] args) throws Exception {
        GTBManager manager = new GTBManager("/home/lmx/MyJava/idea/kgga/resources/conservation/VarNoteDB_ES_Conservation_Aggregation.hg38.gtb");
        GTBReader reader = new GTBReader(manager);
        GTBFilter filter = new GTBFilter(new GTBReaderOption(manager, false, false));
        filter.find(Chromosome.get("chr13"), 48465239);
        long pointer = filter.filter(FoundAction.MOVE_NEXT, NotFoundAction.MOVE_TO_TRY);
        if (pointer != -1L) {
            reader.seek(pointer);
            for (Variant variant : reader.reads()) {
                System.out.println(variant);
            }
        } else {
            System.out.println("Not found");
        }
        filter.close();
    }
}

