/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command;

import edu.sysu.pmglab.ccf.toolkit.filter.IObjectObjectFilter;
import edu.sysu.pmglab.commandParser.CommandOption;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.usage.summary.IParsingSummary;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.io.InputType;

public enum ConflictingOptionRule implements IObjectObjectFilter<CommandOptions, CommandOption<?>>
{
    INSTANCE;

    private final List<IObjectObjectFilter<CommandOptions, CommandOption<?>>> filters = new List();

    private ConflictingOptionRule() {
        this.filters.add(IParsingSummary.disableIf(options -> {
            if (options.contains("-i")) {
                List inputs = (List)options.value("-i");
                for (VariantFileMeta input : inputs) {
                    if (input.type != InputType.MAF) continue;
                    return true;
                }
            }
            return false;
        }, "--hwe-control"));
        this.filters.add(IParsingSummary.enableIf(options -> {
            if (options.contains("-i")) {
                List inputs = (List)options.value("-i");
                for (VariantFileMeta input : inputs) {
                    if (input.type != InputType.VCF) continue;
                    return true;
                }
            }
            return false;
        }, "--gty-gq", "--gty-dp", "--gty-pl", "--gty-ad-hom-ref", "--gty-ad-hom-alt", "--gty-ad-het", "--gty-qc", "--seq-qual", "--seq-fs", "--seq-mq", "--seq-info"));
        this.filters.add(IParsingSummary.disableIf(options -> options.contains("--disable-gene-feature") && options.passed("--disable-gene-feature"), "--gene-model-database", "--gene-feature-included", "--splicing-distance", "--upstream-distance", "--downstream-distance"));
    }

    @Override
    public boolean filter(CommandOptions options, CommandOption<?> option) {
        for (IObjectObjectFilter<CommandOptions, CommandOption<?>> filter : this.filters) {
            if (filter.filter(options, option)) continue;
            return false;
        }
        return true;
    }
}

