/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command;

import ch.qos.logback.classic.Level;
import edu.sysu.pmglab.LogBackOptions;
import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.command.CCFEntry;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.EntryOption;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.io.file.Channel;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.executor.MAFAnnotationProgram;
import edu.sysu.pmglab.kgga.command.executor.PhenoPredictionProgram;
import edu.sysu.pmglab.kgga.command.executor.PrioritizationProgram;
import edu.sysu.pmglab.kgga.command.executor.SimulationProgram;
import edu.sysu.pmglab.kgga.command.executor.VariantAnnotationProgram;
import edu.sysu.pmglab.kgga.command.executor.VariantCleanProgram;
import edu.sysu.pmglab.kgga.command.executor.VariantPruneProgram;
import edu.sysu.pmglab.pyserve.GlobalPythonInterpreter;
import edu.sysu.pmglab.utils.Downloader;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="java -jar kgga.jar <mode> [options]", usage_item={@UsageItem(key="Author", value={"(C) 2022 Miaoxin Li, limx54@163.com"}), @UsageItem(key="About", value={"For documentation, citation & bug-report instructions: http://pmglab.top/kgga/"}), @UsageItem(key="Version", value={"KGGA (last edited on 2025/06/03)"})}, delegation={Channel.class, LogBackOptions.class, GlobalPythonInterpreter.class})
public class SetupApplication
extends ICommandProgram {
    @EntryOption(value={"clean"})
    @OptionUsage(item={@UsageItem(key="Format", value={"clean -i <input> -input <input> ... -o <output> [options]"})}, description={"Generate cleaned genotypes and variants according to quality control and other criteria for further analysis."})
    String[] clean;
    @EntryOption(value={"annotate"})
    @OptionUsage(item={@UsageItem(key="Format", value={"annotate -i <input> -input <input> ... -o <output> [options]"})}, description={"Annotate variants/genes by searching various genomic annotation database and literature evidence."})
    String[] annotate;
    @EntryOption(value={"annotate-maf"})
    @OptionUsage(item={@UsageItem(key="Format", value={"annotate-maf -i <input> -input <input> ... -o <output> [options]"})}, description={"Annotate variants/genes by searching various genomic annotation database and literature evidence."})
    String[] annotateMaf;
    @EntryOption(value={"prune"})
    @OptionUsage(item={@UsageItem(key="Format", value={"prune -i <input> -input <input> ... -o <output> [options]"})}, description={"prune variants according to p-value, LD and annotation."})
    String[] prune;
    @EntryOption(value={"prioritize"})
    @OptionUsage(item={@UsageItem(key="Format", value={"prioritize -i <input> -input <input> ... -o <output> [options]"})}, description={"Prioritize variants or genes for based on allelic frequencies in reference populations."})
    String[] prioritize;
    @EntryOption(value={"predict"})
    @OptionUsage(item={@UsageItem(key="Format", value={"predict -i <input> -input <input> ... -o <output> [options]"})}, description={"Predict phenotypes according to genotypes."}, hidden=true)
    String[] predict;
    @EntryOption(value={"simulate"})
    @OptionUsage(item={@UsageItem(key="Format", value={"predict -i <input> -input <input> ... -o <output> [options]"})}, description={"Simulate phenotypes according to genotypes."}, hidden=true)
    String[] simulate;
    @EntryOption(value={"ccf"})
    @OptionUsage(item={@UsageItem(key="Format", value={"ccf [options]"})}, description={""})
    String[] ccf;
    @EntryOption(value={"gbc"})
    @OptionUsage(item={@UsageItem(key="Format", value={"gbc [options]"})}, description={"Use the GBC package to manage data."})
    String[] gbc;
    @EntryOption(value={"update"})
    @OptionUsage(format="update -o <output>", description={"Update KGGA software packages."})
    String[] update;
    public static final Logger GlobalLogger = LoggerFactory.getLogger("KGGA");
    public static final TaskTracker GlobalTaskTracker;
    public static final String PREL = "KGGA";
    public static final String PVERSION = "1.0";
    public static final String PDATE = "01/Oct/2025";
    public static final String TOOL_URL = "http://pmglab.top/kgga/";
    public static final String RESOURCE_URL = "https://idc.biosino.org/pmglab/resource/kgg/kgga/resources/";
    public static final String LOCAL_RESOURCE_FOLDER = "./resources";

    public static void main(String[] args) {
        String headInfo = "@----------------------------------------------------------@\n|         KGGA         |     v1.0     |    01/Oct/2025     |\n|----------------------------------------------------------|\n|      (C) 2019        PMGLab       limx54@163.com         |\n|----------------------------------------------------------|\n|            Project URL: https://pmglab.top/kgga          |\n@----------------------------------------------------------@";
        LogBackOptions.reset();
        LogBackOptions.addConsoleAppender("%red(%date{yyyy-MM-dd HH:mm:ss}) %cyan(%msg%n)", level -> level.toInt() == Level.INFO.toInt());
        LogBackOptions.addConsoleAppender("%highlight(%-5level) %red(%date{yyyy-MM-dd HH:mm:ss}) %cyan(%msg%n)", level -> level.toInt() != Level.INFO.toInt());
        try {
            GlobalLogger.info("Start\n" + headInfo);
            SetupApplication.execute(args);
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Error | Exception e) {
            if (GlobalLogger.isDebugEnabled()) {
                GlobalLogger.debug("{}", (Object)e.getMessage(), (Object)e);
            } else {
                GlobalLogger.error("{}", (Object)e.getMessage());
            }
            System.exit(1);
        }
    }

    public static void execute(String ... args) throws Exception {
        SetupApplication application = new SetupApplication();
        CommandOptions options = application.parse(args);
        Channel.addChannel(new File(RuntimeProperty.class.getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile() + "/resources");
        Channel.addChannel(new File(RuntimeProperty.class.getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile() + "/resources/liftover");
        Channel.addChannel(LOCAL_RESOURCE_FOLDER);
        Channel.addChannel("./resources/liftover");
        if (options.isHelp()) {
            GlobalLogger.info("\n{}", (Object)options.usage());
            return;
        }
        if (options.passed("update")) {
            SetupApplication.updatePackage();
            return;
        }
        System.setProperty("java.awt.headless", "true");
        if (options.passed("ccf")) {
            CCFEntry.main(application.ccf);
            return;
        }
        if (options.passed("gbc")) {
            CCFEntry.main(application.gbc);
            return;
        }
        if (application.clean != null) {
            VariantCleanProgram.execute(application.clean);
            return;
        }
        if (application.annotate != null) {
            VariantAnnotationProgram.execute(application.annotate);
        }
        if (application.annotateMaf != null) {
            MAFAnnotationProgram.execute(application.annotateMaf);
            return;
        }
        if (application.prune != null) {
            VariantPruneProgram.execute(application.prune);
            return;
        }
        if (application.prioritize != null) {
            PrioritizationProgram.execute(application.prioritize);
            return;
        }
        if (application.predict != null) {
            PhenoPredictionProgram.execute(application.predict);
            return;
        }
        if (application.simulate != null) {
            SimulationProgram.execute(application.simulate);
            return;
        }
    }

    private static void updatePackage() throws IOException {
        File localFile = new File(RuntimeProperty.getClassPath(SetupApplication.class), "kgga.jar");
        if (localFile.exists()) {
            Downloader downloader = new Downloader(LiveFile.of("http://pmglab.top/kgga/download/lib/latest/kgga.jar"), localFile);
            if (downloader.compareTime() != 0) {
                System.out.println("Are you sure the update the current " + localFile.getCanonicalPath() + "? (yes/no)");
                Scanner scanner = new Scanner(System.in);
                String input = scanner.nextLine();
                if (input.equalsIgnoreCase("yes")) {
                    downloader.download();
                    System.out.println("The library of has been updated! Please re-initiate this application!");
                    System.exit(0);
                }
            } else {
                System.out.println("The local file is already the latest version, so it does not need to be updated.");
            }
        } else {
            Downloader downloader = new Downloader(LiveFile.of("http://pmglab.top/kgga/download/lib/latest/kgga.jar"), localFile);
            downloader.download();
        }
    }

    static {
        try {
            GlobalTaskTracker = new TaskTracker();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

