/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command;

import cern.colt.matrix.DoubleMatrix2D;
import ch.qos.logback.classic.Level;
import edu.sysu.pmglab.LogBackOptions;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.container.NamedVarInt64RangeList;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.ShortList;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.executor.IExecutor;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.executor.track.FileTracker;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.task.OutputGenotypes2OtherTask;
import edu.sysu.pmglab.kgga.command.task.RunOtherToolTask;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.kgga.io.InputType;
import edu.sysu.pmglab.progressbar.ProgressBar;
import edu.sysu.pmglab.stat.EffectiveNumberEstimator;
import edu.sysu.pmglab.stat.SpearmanRankCorrelation;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public enum Utility {
    INSTANCE;


    public static void setCacheLog(File workspace) throws IOException {
        if (!workspace.exists() && workspace.mkdirs() && !workspace.exists()) {
            throw new FileSystemException("Readonly file system: " + workspace);
        }
        if (System.getProperty("ccf.cache") == null) {
            // empty if block
        }
        LogBackOptions.addFileAppender(FileUtils.getSubFile(workspace.getCanonicalPath(), "/log/info.log"), level -> level.equals(Level.INFO), "%-5level %date{yyyy-MM-dd HH:mm:ss} %msg%n");
        LogBackOptions.addFileAppender(FileUtils.getSubFile(workspace.getCanonicalPath(), "/log/error.log"), level -> level.equals(Level.ERROR), "%-5level %date{yyyy-MM-dd HH:mm:ss} %logger{50} %msg%n");
    }

    public static void addTrack(IExecutor<?> workflow, File workspace) {
        workflow.addTask((status, context) -> context.setTracker(new FileTracker(FileUtils.getSubFile(workspace.getCanonicalPath(), ".track"))));
    }

    public static String MD5File(File file) throws IOException {
        String msg = file.getCanonicalPath() + "|" + file.length() + "|" + file.lastModified() + "|";
        return ITrack.digest(msg);
    }

    public static String MD5File(LiveFile file) throws IOException {
        String msg = file.getPath() + "|" + file.length() + "|" + file.lastModifyTime() + "|";
        return ITrack.digest(msg);
    }

    public static void checkWhetherOutputGenotypes(GeneralIOOptions generalIOOptions) {
        if (generalIOOptions.plinkOptionsSet != null) {
            generalIOOptions.outputGtyFormat = generalIOOptions.plinkOptionsSet.getInputGTYType();
        } else if (generalIOOptions.gctaOptionsSet != null) {
            generalIOOptions.outputGtyFormat = generalIOOptions.gctaOptionsSet.getInputGTYType();
        } else if (generalIOOptions.plink2OptionsSet != null) {
            generalIOOptions.outputGtyFormat = generalIOOptions.plink2OptionsSet.getInputGTYType();
        }
    }

    public static void genotypOuputAndRunning(GeneralIOOptions generalIOOptions, File workspace, Executor workflow) throws IOException {
        InputType type;
        if (generalIOOptions.outputGtyFormat != null) {
            workflow.addTask(new OutputGenotypes2OtherTask(generalIOOptions, workspace));
            workflow.execute();
            workflow.clearTasks();
        }
        if (generalIOOptions.plink2OptionsSet != null) {
            type = generalIOOptions.plink2OptionsSet.getInputGTYType();
            if (type != generalIOOptions.outputGtyFormat) {
                type = generalIOOptions.outputGtyFormat;
                generalIOOptions.outputGtyFormat = generalIOOptions.plink2OptionsSet.getInputGTYType();
                workflow.addTask(new OutputGenotypes2OtherTask(generalIOOptions, workspace));
            }
            if (type == InputType.PLINK_BED) {
                GlobalPedIndividuals.getIndividuals().export2PlinkFamFile(FileUtils.getSubFile(workspace, InputOutputFileSet.getAnnotationFileNameNoExtension() + ".fam"));
            } else if (type == InputType.PLINK_PGEN) {
                GlobalPedIndividuals.getIndividuals().export2PlinkSamFile(FileUtils.getSubFile(workspace, InputOutputFileSet.getAnnotationFileNameNoExtension() + ".psam"));
            }
            workflow.addTask(new RunOtherToolTask(generalIOOptions, workspace));
            workflow.execute();
            workflow.clearTasks();
            generalIOOptions.outputGtyFormat = type;
        }
        if (generalIOOptions.plinkOptionsSet != null) {
            type = generalIOOptions.plinkOptionsSet.getInputGTYType();
            if (type != generalIOOptions.outputGtyFormat) {
                type = generalIOOptions.outputGtyFormat;
                generalIOOptions.outputGtyFormat = generalIOOptions.plinkOptionsSet.getInputGTYType();
                workflow.addTask(new OutputGenotypes2OtherTask(generalIOOptions, workspace));
            }
            if (type == InputType.PLINK_BED) {
                GlobalPedIndividuals.getIndividuals().export2PlinkFamFile(FileUtils.getSubFile(workspace, InputOutputFileSet.getAnnotationFileNameNoExtension() + ".fam"));
            } else if (type == InputType.PLINK_PGEN) {
                GlobalPedIndividuals.getIndividuals().export2PlinkSamFile(FileUtils.getSubFile(workspace, InputOutputFileSet.getAnnotationFileNameNoExtension() + ".psam"));
            }
            workflow.addTask(new RunOtherToolTask(generalIOOptions, workspace));
            workflow.execute();
            workflow.clearTasks();
            generalIOOptions.outputGtyFormat = type;
        }
        if (generalIOOptions.gctaOptionsSet != null) {
            type = generalIOOptions.gctaOptionsSet.getInputGTYType();
            if (type != generalIOOptions.outputGtyFormat) {
                type = generalIOOptions.outputGtyFormat;
                generalIOOptions.outputGtyFormat = generalIOOptions.gctaOptionsSet.getInputGTYType();
                workflow.addTask(new OutputGenotypes2OtherTask(generalIOOptions, workspace));
            }
            if (type == InputType.PLINK_BED) {
                GlobalPedIndividuals.getIndividuals().export2PlinkFamFile(FileUtils.getSubFile(workspace, InputOutputFileSet.getAnnotationFileNameNoExtension() + ".fam"));
            } else if (type == InputType.PLINK_PGEN) {
                GlobalPedIndividuals.getIndividuals().export2PlinkSamFile(FileUtils.getSubFile(workspace, InputOutputFileSet.getAnnotationFileNameNoExtension() + ".psam"));
            }
            workflow.addTask(new RunOtherToolTask(generalIOOptions, workspace));
            workflow.execute();
            workflow.clearTasks();
            generalIOOptions.outputGtyFormat = type;
        }
    }

    public static Map<String, Map<String, NamedVarInt64RangeList>> assignVariant2GeneRegions(int threadNum, GTBManager manager, CCFIntIndexer<Chromosome> chromosomeTree, boolean considerRegionType) throws IOException {
        AtomicInteger assignedVarNum = new AtomicInteger(0);
        THashMap<String, Map<String, NamedVarInt64RangeList>> chromRegions = new THashMap<String, Map<String, NamedVarInt64RangeList>>();
        ThreadQueue threadPool = new ThreadQueue(threadNum);
        ProgressBar progressBar = new ProgressBar.Builder().setTextRenderer("Processed", "variants").setInitialMax(manager.numOfVariants()).build();
        String[] fields = new String[]{"GeneFeature@HitGenes", "GeneFeature@HitGeneRegionTypes"};
        for (Chromosome curChromosome : chromosomeTree.getTags()) {
            RefinedIntBuckets buckets = chromosomeTree.getTag(curChromosome);
            if (buckets == null) continue;
            GTBReader readerRoot = new GTBReader((GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(fields));
            readerRoot.limit(buckets.getRecordIndexRange());
            readerRoot.seek(0L);
            List<GTBReader> partReaders = readerRoot.part(threadNum);
            int partNum = partReaders.size();
            Map[] chromRegionIDThreads = new THashMap[partNum];
            int k = 0;
            while (k < partNum) {
                chromRegionIDThreads[k] = new THashMap();
                int finalK = k++;
                threadPool.addTask((status1, context1) -> {
                    Variant var;
                    GTBReader partReader = (GTBReader)partReaders.get(finalK);
                    while ((var = partReader.read()) != null) {
                        progressBar.step(1L);
                        IntList geneIDs = (IntList)var.getProperty("GeneFeature@HitGenes");
                        ShortList regionTypeIDs = (ShortList)var.getProperty("GeneFeature@HitGeneRegionTypes");
                        if (geneIDs == null || geneIDs.isEmpty()) continue;
                        long varPointer = partReader.tell() - 1L;
                        int size1 = geneIDs.size();
                        for (int i = 0; i < size1; ++i) {
                            String label = considerRegionType ? geneIDs.fastGet(i) + "#" + regionTypeIDs.fastGet(i) : String.valueOf(geneIDs.fastGet(i));
                            NamedVarInt64RangeList gr = (NamedVarInt64RangeList)chromRegionIDThreads[finalK].get(label);
                            if (gr == null) {
                                gr = new NamedVarInt64RangeList(label);
                                chromRegionIDThreads[finalK].put(label, gr);
                            }
                            gr.add(varPointer);
                            assignedVarNum.getAndIncrement();
                        }
                    }
                });
            }
            threadPool.await();
            for (GTBReader gtbReader : partReaders) {
                gtbReader.close();
            }
            THashMap currentChromRegionMap = new THashMap(chromRegionIDThreads[0]);
            for (int t = 1; t < partNum; ++t) {
                for (Map.Entry entry : chromRegionIDThreads[t].entrySet()) {
                    NamedVarInt64RangeList gr = (NamedVarInt64RangeList)currentChromRegionMap.get(entry.getKey());
                    if (gr != null) {
                        NamedVarInt64RangeList gr1 = (NamedVarInt64RangeList)entry.getValue();
                        TLongIterator pbIters = gr1.iterator();
                        while (pbIters.hasNext()) {
                            long pointer = pbIters.next();
                            gr.add(pointer);
                        }
                        gr.sort();
                        continue;
                    }
                    currentChromRegionMap.put(entry.getKey(), entry.getValue());
                }
            }
            chromRegions.put(curChromosome.getName(), currentChromRegionMap);
        }
        threadPool.close();
        progressBar.close();
        return chromRegions;
    }

    public static float[][] sampleCentralizedGenotypes(File varAnnotFile, int threadNum, int maxQTLNu, long randomSeed, IntList selectedIndexes) throws IOException {
        GTBManager manager = new GTBManager(varAnnotFile);
        String[] necessaryFields = new String[]{"SOURCE@FILE_ID", "SOURCE@FILE_POINTER"};
        LinkedSet<String> neededFields = new LinkedSet<String>(necessaryFields);
        ThreadQueue threadqueue = new ThreadQueue(threadNum);
        GTBReader annotReader = new GTBReader((GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(neededFields));
        THashMap<String, GTBReader> gtyReaders = new THashMap<String, GTBReader>();
        THashMap<String, IntList> gtyIndividualIDs = new THashMap<String, IntList>();
        int subjectNum = GlobalPedIndividuals.size();
        int numRecords = Math.toIntExact(manager.numOfVariants());
        IntList allIndexes = new IntList(numRecords);
        for (int i = 0; i < numRecords; ++i) {
            allIndexes.add(i);
        }
        if (randomSeed != 0L) {
            allIndexes.shuffle(randomSeed);
        } else {
            allIndexes.shuffle(System.nanoTime());
        }
        if (maxQTLNu >= numRecords) {
            maxQTLNu = numRecords;
        }
        IntList addedIndex = new IntList();
        for (int i = selectedIndexes.size(); i < maxQTLNu; ++i) {
            addedIndex.add(allIndexes.fastGet(i));
        }
        allIndexes.clear();
        addedIndex.sort();
        selectedIndexes.addAll(addedIndex);
        int size = selectedIndexes.size();
        float[][] genotypes = new float[maxQTLNu][subjectNum];
        int j = 0;
        while (j < size) {
            IntList subjectIDs;
            int m = selectedIndexes.fastGet(j);
            annotReader.seek(m);
            Variant annotVariant = annotReader.read();
            String fileId = (String)annotVariant.getProperty("SOURCE@FILE_ID");
            long pointer = (Long)annotVariant.getProperty("SOURCE@FILE_POINTER");
            GTBReader gtyReader = (GTBReader)gtyReaders.get(fileId);
            if (gtyReader == null) {
                gtyReader = new GTBReader(fileId);
                gtyReaders.put(fileId, gtyReader);
                subjectIDs = GlobalPedIndividuals.size() > 0 ? GlobalPedIndividuals.getIndividuals().getUIDs().findIndicesIn(gtyReader.getIndividuals()) : null;
                gtyIndividualIDs.put(fileId, subjectIDs);
            } else {
                subjectIDs = (IntList)gtyIndividualIDs.get(fileId);
            }
            gtyReader.seek(pointer);
            Variant gtyVariant = gtyReader.read();
            IntList finalSubjectIDs = subjectIDs;
            int finalJ = j++;
            threadqueue.addTask((status, context) -> {
                int t;
                annotVariant.setGenotypes(gtyVariant.getGenotypes().subGenotypes(finalSubjectIDs).toBiallelic(gtyVariant.indexOfAllele(annotVariant.alleleOfIndex(0)), gtyVariant.indexOfAllele(annotVariant.alleleOfIndex(1)), -1));
                int[][] codes = annotVariant.getGenotypes().getGenotypeCodes();
                gtyVariant.setGenotypes(null);
                annotVariant.setGenotypes(null);
                double missingRate = 0.0;
                double avg = 0.0;
                for (t = 0; t < codes[0].length; ++t) {
                    if (codes[0][t] < 0) {
                        genotypes[finalJ][t] = Float.NaN;
                        missingRate += 1.0;
                        continue;
                    }
                    genotypes[finalJ][t] = codes[0][t] + codes[1][t];
                    avg += (double)genotypes[finalJ][t];
                }
                avg /= (double)codes[0].length - missingRate;
                if ((missingRate /= (double)codes[0].length) > 0.5) {
                    SetupApplication.GlobalLogger.warn("The missing rate is {}", (Object)missingRate);
                }
                for (t = 0; t < codes[0].length; ++t) {
                    if (Float.isNaN(genotypes[finalJ][t])) continue;
                    float[] fArray = genotypes[finalJ];
                    int n = t;
                    fArray[n] = (float)((double)fArray[n] - avg);
                }
            });
        }
        threadqueue.await();
        threadqueue.close();
        annotReader.close();
        for (Map.Entry entry : gtyReaders.entrySet()) {
            ((GTBReader)entry.getValue()).close();
        }
        return genotypes;
    }

    public static float[][] sampleCentralizedGenotypes(File varAnnotFile, int threadNum, int maxQTLNu, long randomSeed, IntList selectedIndexes, IntList retainedIndexes) throws IOException {
        GTBManager manager = new GTBManager(varAnnotFile);
        String[] necessaryFields = new String[]{"SOURCE@FILE_ID", "SOURCE@FILE_POINTER"};
        LinkedSet<String> neededFields = new LinkedSet<String>(necessaryFields);
        ThreadQueue threadqueue = new ThreadQueue(threadNum);
        GTBReader annotReader = new GTBReader((GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(neededFields));
        THashMap<String, GTBReader> gtyReaders = new THashMap<String, GTBReader>();
        THashMap<String, IntList> gtyIndividualIDs = new THashMap<String, IntList>();
        int subjectNum = GlobalPedIndividuals.size();
        int numRecords = (int)manager.numOfVariants();
        if (randomSeed != 0L) {
            retainedIndexes.shuffle(randomSeed);
        } else {
            retainedIndexes.shuffle(System.nanoTime());
        }
        if (maxQTLNu >= numRecords) {
            maxQTLNu = numRecords;
        }
        IntList addedIndex = new IntList();
        for (int i = selectedIndexes.size(); i < maxQTLNu; ++i) {
            addedIndex.add(retainedIndexes.fastGet(i));
        }
        addedIndex.sort();
        selectedIndexes.addAll(addedIndex);
        int size = selectedIndexes.size();
        float[][] genotypes = new float[maxQTLNu][subjectNum];
        int j = 0;
        while (j < size) {
            IntList subjectIDs;
            int m = selectedIndexes.fastGet(j);
            annotReader.seek(m);
            Variant annotVariant = annotReader.read();
            String fileId = (String)annotVariant.getProperty("SOURCE@FILE_ID");
            long pointer = (Long)annotVariant.getProperty("SOURCE@FILE_POINTER");
            GTBReader gtyReader = (GTBReader)gtyReaders.get(fileId);
            if (gtyReader == null) {
                gtyReader = new GTBReader(fileId);
                gtyReaders.put(fileId, gtyReader);
                subjectIDs = GlobalPedIndividuals.size() > 0 ? GlobalPedIndividuals.getIndividuals().getUIDs().findIndicesIn(gtyReader.getIndividuals()) : null;
                gtyIndividualIDs.put(fileId, subjectIDs);
            } else {
                subjectIDs = (IntList)gtyIndividualIDs.get(fileId);
            }
            gtyReader.seek(pointer);
            Variant gtyVariant = gtyReader.read();
            IntList finalSubjectIDs = subjectIDs;
            int finalJ = j++;
            threadqueue.addTask((status, context) -> {
                int t;
                annotVariant.setGenotypes(gtyVariant.getGenotypes().subGenotypes(finalSubjectIDs).toBiallelic(gtyVariant.indexOfAllele(annotVariant.alleleOfIndex(0)), gtyVariant.indexOfAllele(annotVariant.alleleOfIndex(1)), -1));
                int[][] codes = annotVariant.getGenotypes().getGenotypeCodes();
                gtyVariant.setGenotypes(null);
                annotVariant.setGenotypes(null);
                double missingRate = 0.0;
                double avg = 0.0;
                for (t = 0; t < codes[0].length; ++t) {
                    if (codes[0][t] < 0) {
                        genotypes[finalJ][t] = Float.NaN;
                        missingRate += 1.0;
                        continue;
                    }
                    genotypes[finalJ][t] = codes[0][t] + codes[1][t];
                    avg += (double)genotypes[finalJ][t];
                }
                avg /= (double)codes[0].length - missingRate;
                if ((missingRate /= (double)codes[0].length) > 0.5) {
                    SetupApplication.GlobalLogger.warn("The missing rate is {}", (Object)missingRate);
                }
                for (t = 0; t < codes[0].length; ++t) {
                    if (Float.isNaN(genotypes[finalJ][t])) continue;
                    genotypes[finalJ][t] = (float)((double)genotypes[finalJ][t] - avg);
                }
            });
        }
        threadqueue.await();
        threadqueue.close();
        annotReader.close();
        for (Map.Entry entry : gtyReaders.entrySet()) {
            ((GTBReader)entry.getValue()).close();
        }
        return genotypes;
    }

    public static DoubleList[] collectVariantScoreList(GTBManager inputManager, String[] toBeMergedScores, DoubleMatrix2D corMatrix, int threadNum, int maxNum, boolean toSortDataList) throws IOException {
        List<GTBReader> partReaders = new GTBReader(new GTBReaderOption(inputManager, false, true)).part(threadNum);
        threadNum = partReaders.size();
        ThreadQueue threadPool = new ThreadQueue(threadNum);
        DoubleList[] allScores = new DoubleList[toBeMergedScores.length];
        for (int i = 0; i < allScores.length; ++i) {
            allScores[i] = new DoubleList();
        }
        int k = 0;
        while (k < threadNum) {
            int finalK = k++;
            threadPool.addTask((status1, context1) -> {
                Variant var;
                GTBReader partReader = (GTBReader)partReaders.get(finalK);
                float[] tmpValues = new float[toBeMergedScores.length];
                boolean hasNA = false;
                while ((var = partReader.read()) != null) {
                    hasNA = false;
                    for (int i = 0; i < tmpValues.length; ++i) {
                        tmpValues[i] = ((Float)var.getProperty(toBeMergedScores[i])).floatValue();
                        if (!Float.isNaN(tmpValues[i])) continue;
                        hasNA = true;
                        break;
                    }
                    if (hasNA) continue;
                    DoubleList[] doubleListArray = allScores;
                    // MONITORENTER : allScores
                    for (int i = 0; i < tmpValues.length; ++i) {
                        allScores[i].add(tmpValues[i]);
                    }
                    // MONITOREXIT : doubleListArray
                    if (allScores[0].size() < maxNum) continue;
                }
                partReader.close();
            });
        }
        threadPool.await();
        partReaders.close();
        int scoreNum = allScores[0].size();
        for (int i = 0; i < allScores.length; ++i) {
            corMatrix.setQuick(i, i, 1.0);
            int i1 = i;
            int j = i + 1;
            while (j < allScores.length) {
                int j1 = j++;
                threadPool.addTask((status, context1) -> {
                    DoubleList scores1 = new DoubleList();
                    DoubleList scores2 = new DoubleList();
                    scores1.clear();
                    scores2.clear();
                    for (int k = 0; k < scoreNum; ++k) {
                        double score1 = allScores[i1].get(k);
                        double score2 = allScores[j1].get(k);
                        if (Double.isNaN(score1) || Double.isNaN(score2)) continue;
                        scores1.add(score1);
                        scores2.add(score2);
                    }
                    double cor = SpearmanRankCorrelation.spearman(scores1.toArray(), scores2.toArray());
                    corMatrix.setQuick(i1, j1, cor);
                    corMatrix.setQuick(j1, i1, cor);
                    scores1.clear();
                    scores2.clear();
                });
            }
        }
        threadPool.close();
        if (toSortDataList) {
            for (DoubleList allScore : allScores) {
                allScore.sort();
            }
        } else {
            for (DoubleList allScore : allScores) {
                allScore.close();
            }
        }
        return allScores;
    }

    public static float standardizeEffectivelyIndependentAverageScores(float[] tmpValues, DoubleList[] allSortedScores, DoubleMatrix2D corMatrix, boolean toStandardize) {
        List<float[]> scoreIndexes = new List<float[]>();
        for (int i = 0; i < tmpValues.length; ++i) {
            if (Float.isNaN(tmpValues[i])) continue;
            scoreIndexes.add(new float[]{i, tmpValues[i]});
        }
        if (scoreIndexes.isEmpty()) {
            return Float.NaN;
        }
        scoreIndexes.sort((o1, o2) -> Float.compare(o2[1], o1[1]));
        IntList effectiveIndexes = new IntList();
        for (float[] item : scoreIndexes) {
            effectiveIndexes.add((int)item[0]);
        }
        double[] effectiveCounts = EffectiveNumberEstimator.calculateEffectiveIndexesDiff(corMatrix, effectiveIndexes.toArray());
        double effectiveTotal = 0.0;
        for (double effectiveCount : effectiveCounts) {
            effectiveTotal += effectiveCount;
        }
        int effectiveScoreNum = effectiveIndexes.size();
        int nonNANum = 0;
        double sumScores = 0.0;
        float avgScore = Float.NaN;
        for (int j = 0; j < effectiveScoreNum; ++j) {
            float varScore = tmpValues[effectiveIndexes.get(j)];
            if (Float.isNaN(varScore)) continue;
            double varScore1 = varScore;
            if (toStandardize) {
                int index1;
                if (allSortedScores[effectiveIndexes.get(j)].get(0) == varScore1) {
                    index1 = 0;
                } else {
                    index1 = allSortedScores[effectiveIndexes.get(j)].binarySearch(varScore1);
                    if (index1 < 0) {
                        index1 = -index1 - 1;
                    }
                }
                if (index1 < allSortedScores[effectiveIndexes.get(j)].size()) {
                    while (allSortedScores[effectiveIndexes.get(j)].get(index1) == varScore1 && --index1 > 0) {
                    }
                    if (index1 < 0) {
                        index1 = 0;
                    }
                }
                varScore1 = index1;
                varScore1 /= (double)allSortedScores[effectiveIndexes.get(j)].size();
            }
            sumScores += varScore1 * effectiveCounts[j];
            ++nonNANum;
        }
        if (nonNANum > 0) {
            avgScore = (float)(sumScores / effectiveTotal);
        }
        return avgScore;
    }
}

