/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.executor;

import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.Variant2Variant;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.command.task.ConvertMAF2GTBTask;
import edu.sysu.pmglab.kgga.command.task.OutputVariants2TSVTask;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="annotate-maf --input <input> --input <input> ... -o <output> [options]", usage_item={@UsageItem(key="About", value={"annotate-maf --input <input> --input <input>  ... -o <output> [options]"})})
public class MAFAnnotationProgram
extends ICommandProgram {
    @Option(names={"annotate-maf"}, type=FieldType.NULL, bind=false)
    private static final Logger logger = LoggerFactory.getLogger(MAFAnnotationProgram.class);
    @OptionBundle
    private final GeneralIOOptions generalIOOptions = new GeneralIOOptions();
    @OptionBundle
    VCFQualityControlOptions vcfQCOption = new VCFQualityControlOptions();
    @OptionBundle
    private final AnnotationOptions annotationOptions = new AnnotationOptions();

    public static void execute(String ... args) throws Exception, Error {
        GTBManager annotationBasedGTB;
        String[] stringArray;
        MAFAnnotationProgram program = new MAFAnnotationProgram();
        if (args.length == 1 && args[0].equals("annotate-maf")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            logger.info("\n{}", (Object)options.usage());
            return;
        }
        File workspace = (File)options.value("--output");
        Utility.setCacheLog(workspace);
        logger.info("\n{}", (Object)options);
        Executor workflow = new Executor();
        Utility.addTrack(workflow, workspace);
        workflow.execute();
        workflow.clearTasks();
        List originalInputs = (List)options.value("--input");
        List<GTBManager> gtbManagers = new List<GTBManager>();
        for (VariantFileMeta orgInput : originalInputs) {
            workflow.addTask(new ConvertMAF2GTBTask(program.generalIOOptions, orgInput, true, workspace, true));
            workflow.execute();
            workflow.clearTasks();
            VariantFileMeta fileSet = (VariantFileMeta)workflow.getParam("ConvertedOriginalGTBInputVariantFileSet");
            gtbManagers.add(fileSet.getGTB());
        }
        if (gtbManagers.size() > 1) {
            File outputAnnotFile = FileUtils.getSubFile(new File(workspace + "/ConvertMAF2GTBTask/"), InputOutputFileSet.getAnnotationFileName());
            Processor.setInputs(gtbManagers.apply(GTBInputOption::new)).setOutput(new GTBOutputOption(outputAnnotFile)).bridge(new Variant2Variant()).setListener(new InputOutputListener()).submit((Integer)options.value("--threads"));
            annotationBasedGTB = new GTBManager(outputAnnotFile);
        } else {
            annotationBasedGTB = (GTBManager)gtbManagers.get(0);
        }
        workflow.setParam("AnnotationBaseVariantSet", new File(annotationBasedGTB.getFile().getPath()));
        workflow.addTask(new AnnotationPipeline(program.annotationOptions, workspace, program.generalIOOptions.threads).build());
        workflow.execute();
        workflow.clearTasks();
        String[] outputGroups = new String[]{"TEXT"};
        String[] otherFields = new String[]{"MarkFeatureGene", "MarkGeneFeature"};
        workflow.addTask(new OutputVariants2TSVTask(workspace, outputGroups, otherFields));
        workflow.execute();
        workflow.clearTasks();
    }
}

