/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.executor;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.rule.Functional;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.ConflictingOptionRule;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.LDPruneOptions;
import edu.sysu.pmglab.kgga.command.pipeline.PhenoPredictionOptions;
import edu.sysu.pmglab.kgga.command.pipeline.PreprocessingPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.GwasSumFileOption;
import edu.sysu.pmglab.kgga.command.task.AppendVariants2RootVariantSetTask;
import edu.sysu.pmglab.kgga.command.task.LDPruningTask;
import edu.sysu.pmglab.kgga.command.task.OutputGenotypes2OtherTask;
import edu.sysu.pmglab.kgga.command.task.OutputVariants2TSVTask;
import edu.sysu.pmglab.kgga.command.task.TrainLEAPModelTask1;
import edu.sysu.pmglab.kgga.command.task.VariantAssocTask1;
import edu.sysu.pmglab.kgga.io.InputType;
import java.io.File;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="predict -i <input> -i <input> ... -o <output> [options]", usage_item={@UsageItem(key="About", value={"predict <input> <input> ... -o <output> [options]\npredict phenotypes."})}, summary_filter={ConflictingOptionRule.class, VCFQualityControlOptions.QCOptionsDisplayFilter.class}, rule=@Rule(function={@Functional(item=VCFQualityControlOptions.QCOptionsRule.class)}))
public class PhenoPredictionProgram
extends ICommandProgram {
    @Option(names={"predict"}, type=FieldType.NULL, bind=false)
    private static final Logger logger = LoggerFactory.getLogger(PhenoPredictionProgram.class);
    @OptionBundle
    final VCFQualityControlOptions vcfQCOption = new VCFQualityControlOptions();
    @OptionBundle
    private final GeneralIOOptions generalIOOptions = new GeneralIOOptions();
    @OptionBundle
    private final AnnotationOptions annotationOptions = new AnnotationOptions();
    @OptionBundle
    private final LDPruneOptions ldPruneOptions = new LDPruneOptions();
    @OptionBundle
    private final PhenoPredictionOptions phenoPredictionOptions = new PhenoPredictionOptions();

    public static void execute(String ... args) throws Exception, Error {
        String[] stringArray;
        PhenoPredictionProgram program = new PhenoPredictionProgram();
        if (args.length == 1 && args[0].equals("predict")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            logger.info("\n{}", (Object)options.usage());
            return;
        }
        File workspace = (File)options.value("--output");
        Utility.setCacheLog(workspace);
        logger.info("\n{}", (Object)options);
        Executor workflow = new Executor();
        workflow.setParam(VCFQualityControlOptions.class, program.vcfQCOption);
        Utility.addTrack(workflow, workspace);
        workflow.execute();
        workflow.clearTasks();
        InputType inputGtyType = program.generalIOOptions.outputGtyFormat;
        program.generalIOOptions.outputGtyFormat = InputType.GTB;
        GTBManager annotationBasedGTB = PreprocessingPipeline.INSTANCE.generateAnnotationBase(program.generalIOOptions, program.vcfQCOption, workflow, workspace);
        workflow.setParam("AnnotationBaseVariantSet", new File(annotationBasedGTB.getFile().getPath()));
        workflow.addTask(new AnnotationPipeline(program.annotationOptions, workspace, program.generalIOOptions.threads).build());
        workflow.execute();
        workflow.clearTasks();
        if (program.ldPruneOptions.pruneP > 0.0) {
            workflow.addTask(new VariantAssocTask1(workspace, true, program.generalIOOptions, program.ldPruneOptions));
            workflow.execute();
            workflow.clearTasks();
        }
        String[] pFieldNames = null;
        List<GwasSumFileOption> summaryFiles = program.generalIOOptions.gwasSumFileOptions;
        if (summaryFiles != null) {
            List<String> pFieldList = new List<String>();
            for (GwasSumFileOption gwasSumFileOption : summaryFiles) {
                List<LiveFile> gwasFiles = gwasSumFileOption.inputFiles;
                Iterator<LiveFile> iterator2 = gwasFiles.iterator();
                while (iterator2.hasNext()) {
                    LiveFile liveFile;
                    gwasSumFileOption.tmpActiveInputFile = liveFile = iterator2.next();
                    workflow.addTask(new AppendVariants2RootVariantSetTask(gwasSumFileOption, workspace, true, program.generalIOOptions.threads));
                    workflow.execute();
                    workflow.clearTasks();
                    pFieldList.add(liveFile.getName() + "@P");
                }
            }
            pFieldNames = pFieldList.toArray((T1[])new String[0]);
        }
        if (program.ldPruneOptions.pruneR2 > 0.0f) {
            workflow.addTask(new LDPruningTask(program.ldPruneOptions, pFieldNames, workspace, true, program.generalIOOptions.threads));
            workflow.execute();
            workflow.clearTasks();
        }
        workflow.addTask(new TrainLEAPModelTask1(program.generalIOOptions, pFieldNames, program.phenoPredictionOptions, workspace, true));
        workflow.execute();
        workflow.clearTasks();
        program.generalIOOptions.outputGtyFormat = inputGtyType;
        if (program.generalIOOptions.outputGtyFormat != null) {
            workflow.addTask(new OutputGenotypes2OtherTask(program.generalIOOptions, workspace));
        }
        workflow.addTask(new OutputVariants2TSVTask(workspace, program.generalIOOptions.threads));
        workflow.execute();
    }
}

