/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.executor;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.rule.Counter;
import edu.sysu.pmglab.commandParser.annotation.rule.Functional;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.kgga.command.ConflictingOptionRule;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.MutationCountAdjustPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.MutationCountAnalysisOptions;
import edu.sysu.pmglab.kgga.command.pipeline.PreprocessingPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.DatabaseFieldValidator;
import edu.sysu.pmglab.kgga.io.InputType;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="prioritize --input <input> --input <input> ... -o <output> [options]", usage_item={@UsageItem(key="About", value={"prioritize -i <input> -i <input> ... -o <output> [options]\nPrioritize variants or genes for based on allelic frequencies in reference populations."})}, summary_filter={ConflictingOptionRule.class, VCFQualityControlOptions.QCOptionsDisplayFilter.class}, rule=@Rule(function={@Functional(item=VCFQualityControlOptions.QCOptionsRule.class)}, counter={@Counter(item={"--afgre", "--runner", "--mcvs", "--gene-set-assoc"}, rule=Counter.Type.AT_LEAST, description="please specify at least one of the following options:'--afgre' '--runner' '--mcvs' '--gene-set-assoc'")}))
public class PrioritizationProgram
extends ICommandProgram {
    @Option(names={"prioritize"}, type=FieldType.NULL, bind=false)
    private static final Logger logger = LoggerFactory.getLogger(PrioritizationProgram.class);
    @OptionBundle
    private final VCFQualityControlOptions vcfQualityControlOptions = new VCFQualityControlOptions();
    @OptionBundle
    private final GeneralIOOptions inputsOptions = new GeneralIOOptions();
    @OptionBundle
    private final AnnotationOptions annotationOptions = new AnnotationOptions();
    @OptionBundle
    private final MutationCountAnalysisOptions mutationCountAnalysisOptions = new MutationCountAnalysisOptions();

    public static void execute(String ... args) throws Exception, Error {
        String[] stringArray;
        PrioritizationProgram program = new PrioritizationProgram();
        if (args.length == 1 && args[0].equals("prioritize")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            logger.info("\n{}", (Object)options.usage());
            return;
        }
        File mainWorkspace = (File)options.value("--output");
        Utility.setCacheLog(mainWorkspace);
        logger.info("\n{}", (Object)options);
        DatabaseFieldValidator.checkingMissingFieldsInDatabase(options);
        Executor mainExecutor = new Executor();
        Utility.addTrack(mainExecutor, mainWorkspace);
        program.inputsOptions.outputGtyFormat = InputType.GTB;
        GTBManager annotationBasedGTB = PreprocessingPipeline.INSTANCE.generateAnnotationBase(program.inputsOptions, program.vcfQualityControlOptions, mainExecutor, mainWorkspace);
        mainExecutor.setParam("AnnotationBaseVariantSet", new File(annotationBasedGTB.getFile().getPath()));
        mainExecutor.addTask(new AnnotationPipeline(program.annotationOptions, mainWorkspace, program.inputsOptions.threads).build());
        mainExecutor.execute();
        mainExecutor.clearTasks();
        if (program.mutationCountAnalysisOptions.countRegressionRunnerSetting != null || program.mutationCountAnalysisOptions.afgre != null) {
            MutationCountAdjustPipeline.INSTANCE.afgreAndRunnerExecutor(program.inputsOptions, program.vcfQualityControlOptions, program.annotationOptions, program.mutationCountAnalysisOptions, mainExecutor, mainWorkspace);
        } else if (program.mutationCountAnalysisOptions.countRegressionVSRSetting != null) {
            MutationCountAdjustPipeline.INSTANCE.variableScannedRegionExecutor(program.inputsOptions, program.annotationOptions, program.mutationCountAnalysisOptions, mainExecutor, mainWorkspace);
        } else if (program.mutationCountAnalysisOptions.geneSetAssocSetting != null) {
            MutationCountAdjustPipeline.INSTANCE.geneSetAssocExecutor(program.inputsOptions, program.annotationOptions, program.mutationCountAnalysisOptions, mainExecutor, mainWorkspace);
        }
    }
}

