/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.executor;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.rule.Functional;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.kgga.command.ConflictingOptionRule;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.PreprocessingPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.task.OutputGenotypes2OtherTask;
import edu.sysu.pmglab.kgga.command.task.OutputVariants2TSVTask;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="annotate --input <input> --input <input> ... -o <output> [options]", usage_item={@UsageItem(key="About", value={"annotate <input> <input> ... -o <output> [options]"})}, summary_filter={ConflictingOptionRule.class, VCFQualityControlOptions.QCOptionsDisplayFilter.class}, rule=@Rule(function={@Functional(item=VCFQualityControlOptions.QCOptionsRule.class)}))
public class VariantAnnotationProgram
extends ICommandProgram {
    @Option(names={"annotate"}, type=FieldType.NULL, bind=false)
    private static final Logger logger = LoggerFactory.getLogger(VariantAnnotationProgram.class);
    @OptionBundle
    private final GeneralIOOptions inputsOptions = new GeneralIOOptions();
    @OptionBundle
    private final VCFQualityControlOptions vcfQCOption = new VCFQualityControlOptions();
    @OptionBundle
    private final AnnotationOptions annotationOptions = new AnnotationOptions();

    public static void execute(String ... args) throws Exception, Error {
        String[] stringArray;
        VariantAnnotationProgram program = new VariantAnnotationProgram();
        if (args.length == 1 && args[0].equals("annotate")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            logger.info("\n{}", (Object)options.usage());
            return;
        }
        File workspace = (File)options.value("--output");
        Utility.setCacheLog(workspace);
        logger.info("\n{}", (Object)options);
        Executor workflow = new Executor();
        Utility.addTrack(workflow, workspace);
        workflow.execute();
        workflow.clearTasks();
        GTBManager annotationBasedGTB = PreprocessingPipeline.INSTANCE.generateAnnotationBase(program.inputsOptions, program.vcfQCOption, workflow, workspace);
        workflow.setParam("AnnotationBaseVariantSet", new File(annotationBasedGTB.getFile().getPath()));
        workflow.addTask(new AnnotationPipeline(program.annotationOptions, workspace, program.inputsOptions.threads).build());
        workflow.execute();
        workflow.clearTasks();
        workflow.addTask(new OutputVariants2TSVTask(workspace, program.inputsOptions.threads));
        if (program.inputsOptions.outputGtyFormat != null) {
            workflow.addTask(new OutputGenotypes2OtherTask(program.inputsOptions, workspace));
        }
        workflow.execute();
        workflow.clearTasks();
    }
}

