/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.executor;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.rule.Functional;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.file.Channel;
import edu.sysu.pmglab.kgga.command.ConflictingOptionRule;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.PreprocessingPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.task.OutputVariants2TSVTask;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="clean -i <input> -i <input> ... -o <output> [options]", usage_item={@UsageItem(key="About", value={"filter <input> <input> ... -o <output> [options]\nRemove genotypes and variants according to quality control and other criteria."})}, summary_filter={ConflictingOptionRule.class, VCFQualityControlOptions.QCOptionsDisplayFilter.class}, rule=@Rule(function={@Functional(item=VCFQualityControlOptions.QCOptionsRule.class)}), delegation={Channel.class})
public class VariantCleanProgram
extends ICommandProgram {
    @Option(names={"clean"}, bind=false, type=FieldType.NULL)
    private static final Logger logger = LoggerFactory.getLogger(VariantCleanProgram.class);
    @OptionBundle
    final VCFQualityControlOptions vcfQCOption = new VCFQualityControlOptions();
    @OptionBundle
    private final GeneralIOOptions generalIOOptions = new GeneralIOOptions();

    public static void main(String[] args) throws IOException {
        Channel.addChannel(RuntimeProperty.WORKSPACE_PATH.getCanonicalPath());
        System.out.println(new File(SetupApplication.class.getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile());
    }

    public static void execute(String ... args) throws Exception, Error {
        String[] stringArray;
        VariantCleanProgram program = new VariantCleanProgram();
        if (args.length == 1 && args[0].equals("clean")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            logger.info("\n{}", (Object)options.usage());
            return;
        }
        File workspace = (File)options.value("--output");
        Utility.setCacheLog(workspace);
        logger.info("\n{}", (Object)options);
        Executor workflow = new Executor();
        Utility.addTrack(workflow, workspace);
        workflow.execute();
        workflow.clearTasks();
        Utility.checkWhetherOutputGenotypes(program.generalIOOptions);
        GTBManager annotationBasedGTB = PreprocessingPipeline.INSTANCE.generateAnnotationBase(program.generalIOOptions, program.vcfQCOption, workflow, workspace);
        workflow.execute();
        workflow.clearTasks();
        workflow.setParam("AnnotationBaseVariantSet", new File(annotationBasedGTB.getFile().getPath()));
        workflow.addTask(new OutputVariants2TSVTask(workspace, false, program.generalIOOptions.threads));
        workflow.execute();
        workflow.clearTasks();
        Utility.genotypOuputAndRunning(program.generalIOOptions, workspace, workflow);
        workflow.execute();
        workflow.clearTasks();
    }
}

