/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.executor;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.rule.Functional;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.kgga.command.ConflictingOptionRule;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.LDPruneOptions;
import edu.sysu.pmglab.kgga.command.pipeline.PreprocessingPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.task.LDPruningTask;
import edu.sysu.pmglab.kgga.command.task.OutputGenotypes2OtherTask;
import edu.sysu.pmglab.kgga.command.task.OutputVariants2TSVTask;
import edu.sysu.pmglab.kgga.command.task.VariantAssocTask;
import edu.sysu.pmglab.kgga.io.InputType;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="prune -i <input> -i <input> ... -o <output> [options]", usage_item={@UsageItem(key="About", value={"prune <input> <input> ... -o <output> [options]\nprune variants according to p-value, LD and annotation."})}, summary_filter={ConflictingOptionRule.class, VCFQualityControlOptions.QCOptionsDisplayFilter.class}, rule=@Rule(function={@Functional(item=VCFQualityControlOptions.QCOptionsRule.class)}))
public class VariantPruneProgram
extends ICommandProgram {
    @Option(names={"prune"}, type=FieldType.NULL, bind=false)
    private static final Logger logger = LoggerFactory.getLogger(VariantPruneProgram.class);
    @OptionBundle
    final VCFQualityControlOptions vcfQCOption = new VCFQualityControlOptions();
    @OptionBundle
    private final GeneralIOOptions generalIOOptions = new GeneralIOOptions();
    @OptionBundle
    private final AnnotationOptions annotationOptions = new AnnotationOptions();
    @OptionBundle
    private final LDPruneOptions ldPruneOptions = new LDPruneOptions();

    public static void execute(String ... args) throws Exception, Error {
        String[] stringArray;
        VariantPruneProgram program = new VariantPruneProgram();
        if (args.length == 1 && args[0].equals("prune")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            logger.info("\n{}", (Object)options.usage());
            return;
        }
        if (program.ldPruneOptions.pruneR2 < 0.0f && program.ldPruneOptions.pruneP < 0.0) {
            logger.error("\n{}", (Object)"No prune options [--r2-cut] or [--p-cut] specified");
            return;
        }
        File workspace = (File)options.value("--output");
        Utility.setCacheLog(workspace);
        logger.info("\n{}", (Object)options);
        Executor workflow = new Executor();
        workflow.setParam(VCFQualityControlOptions.class, program.vcfQCOption);
        Utility.addTrack(workflow, workspace);
        workflow.execute();
        workflow.clearTasks();
        InputType inputGtyType = program.generalIOOptions.outputGtyFormat;
        program.generalIOOptions.outputGtyFormat = InputType.GTB;
        GTBManager annotationBasedGTB = PreprocessingPipeline.INSTANCE.generateAnnotationBase(program.generalIOOptions, program.vcfQCOption, workflow, workspace);
        workflow.setParam("AnnotationBaseVariantSet", new File(annotationBasedGTB.getFile().getPath()));
        workflow.addTask(new AnnotationPipeline(program.annotationOptions, workspace, program.generalIOOptions.threads).build());
        workflow.execute();
        workflow.clearTasks();
        if (program.ldPruneOptions.pruneP > 0.0) {
            workflow.addTask(new VariantAssocTask(workspace, true, program.generalIOOptions, program.ldPruneOptions));
            workflow.execute();
            workflow.clearTasks();
        }
        if (program.ldPruneOptions.pruneR2 > 0.0f) {
            if (program.annotationOptions.noGeneFeature) {
                // empty if block
            }
            workflow.addTask(new LDPruningTask(program.ldPruneOptions, null, workspace, true, program.generalIOOptions.threads));
        }
        program.generalIOOptions.outputGtyFormat = inputGtyType;
        if (program.generalIOOptions.outputGtyFormat != null || program.generalIOOptions.plinkOptionsSet != null) {
            workflow.addTask(new OutputGenotypes2OtherTask(program.generalIOOptions, workspace));
            if (program.generalIOOptions.plinkOptionsSet != null) {
                // empty if block
            }
        }
        workflow.addTask(new OutputVariants2TSVTask(workspace, program.generalIOOptions.threads));
        workflow.execute();
    }
}

