/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.pipeline;

import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.annotation.database.DatabaseDescriptionConverter;
import edu.sysu.pmglab.annotation.database.IntervalDatabaseDescription;
import edu.sysu.pmglab.annotation.database.IntervalDatabaseDescriptionConverter;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.validator.range.Int_0_RangeValidator;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import java.util.Set;

public class AnnotationOptions {
    @DynamicOption(names={"--freq-database", "-fd"}, args={"name", "path=", "field=", "type=GTB"}, converter=DatabaseDescriptionConverter.class, repeated=true, arbitrary=true)
    @OptionUsage(description={"Set the reference databases used for allele frequency annotation. The <name> is identified as the database name (such as gnomad), and the <field> is identified as the specified field filtered under this database. If no value is set, all fields of the specified database are selected by default."}, item={@UsageItem(key="format", value={"--freq-database <name> field=[field1,field2,...] path=[file/path](optional)"})})
    public List<DatabaseDescription> freqDatabase = new List();
    @Option(names={"--db-af"}, type=FieldType.floatInterval)
    @OptionUsage(description={"Exclude variants with alternative allele frequency (AF) outside the range [min, max] in frequency databases."}, item={@UsageItem(key="format", value={"--db-af <min>~<max>"})})
    public FloatInterval dbAf = new FloatInterval(0.0f, 1.0f);
    @Option(names={"--db-maf"}, type=FieldType.floatInterval)
    @OptionUsage(description={"Exclude variants with minor allele frequency (AF) outside the range [min, max] in frequency databases."}, item={@UsageItem(key="format", value={"--db-maf <min>~<max>"})})
    public FloatInterval dbMaf = new FloatInterval(0.0f, 1.0f);
    @DynamicOption(names={"--exp-database", "-ed"}, args={"name", "path=", "field=", "type=GTB"}, converter=DatabaseDescriptionConverter.class, repeated=true, arbitrary=true)
    @OptionUsage(description={"Set the reference databases used for expression annotation at variants."}, item={@UsageItem(key="format", value={"--exp-database <name> field=[field1,field2,...] path=[file/path](optional)"})})
    public List<DatabaseDescription> expDatabase = new List();
    @Option(names={"--exp-range"}, type=FieldType.floatInterval)
    @OptionUsage(description={"Exclude variants with alternative allele frequency (AF) outside the range [min, max] in frequency databases."}, item={@UsageItem(key="format", value={"--exp-range <min>~<max>"})})
    public FloatInterval expRange;
    @DynamicOption(names={"--variant-annotation-database", "-vad"}, args={"name", "path=", "field=", "type=GTB"}, converter=DatabaseDescriptionConverter.class, repeated=true, arbitrary=true)
    @OptionUsage(description={"Set the reference databases used for annotation at variants."}, item={@UsageItem(key="format", value={"--variant-annotation-database <name> field=[field1,field2,...] path=[file/path](optional)"})})
    public List<DatabaseDescription> varAnnotDatabase = new List();
    @DynamicOption(names={"--region-annotation-database", "-rad"}, args={"name=", "path=", "subID=", "marker=", "field="}, converter=IntervalDatabaseDescriptionConverter.class, repeated=true)
    @OptionUsage(description={"Set the reference databases used for annotation at variants."}, item={@UsageItem(key="format", value={"--region-annotation-database <name> subID=[] marker=[] path=[file/path] field=[] (optional)"})})
    public List<IntervalDatabaseDescription> epigeneAnnotDatabase = new List();
    @DynamicOption(names={"--gene-model-database", "-gmd"}, args={"name=", "path="}, converter=DatabaseDescriptionConverter.class, repeated=true, arbitrary=true)
    @OptionUsage(description={"Set the reference gene model databases for gene feature annotation."}, defaultTo="refgene", item={@UsageItem(key="format", value={"--gene-model-database <name> path=[file/path](optional)"})})
    public List<DatabaseDescription> geneDatabase = List.singleton(new DatabaseDescription("refgene", null, null));
    @Option(names={"--gene-feature-included", "-gfi"}, type=FieldType.varInt32RangeList)
    @OptionUsage(description={"Retain variants with specified annotated gene features."}, defaultTo="0~17", item={@UsageItem(key="format", value={"--gene-feature-included <int~int>,<int>,..."})})
    public VarInt32RangeList geneFeatureIn = new VarInt32RangeList().addInterval(0, 17);
    @Option(names={"--gene-excluded", "-ge"}, type=FieldType.stringSet)
    @OptionUsage(description={"Exclude variants with specified genes."}, item={@UsageItem(key="format", value={"--gene-excluded GeneSymbol1,GeneSymbol2,..."})})
    public Set<String> geneExcluded = null;
    @Option(names={"--gene-retained", "-gr"}, type=FieldType.stringSet)
    @OptionUsage(description={"Retain variants with specified genes."}, item={@UsageItem(key="format", value={"--gene-retained GeneSymbol1,GeneSymbol2,..."})})
    public Set<String> geneRetained = null;
    @Option(names={"--splicing-distance"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class)
    @OptionUsage(description={"Set the base-pairs distance for defining splicing junction variants."}, defaultTo="3", item={@UsageItem(key="format", value={"--splicing-distance <int>"})})
    public int splicingDis = 3;
    @Option(names={"--upstream-distance"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class)
    @OptionUsage(description={"Set the region length (bp) of upstream from transcription start site."}, defaultTo="1000", item={@UsageItem(key="format", value={"--upstream-distance <int>"})})
    public int upstreamDis = 1000;
    @Option(names={"--downstream-distance"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class)
    @OptionUsage(description={"Set the region length (bp) of downstream from transcription start site."}, defaultTo="1000", item={@UsageItem(key="format", value={"--downstream-distance <int>"})})
    public int downstreamDis = 1000;
    @Option(names={"--disable-gene-feature", "-ngf"}, type=FieldType.NULL)
    @OptionUsage(description={"Disable gene feature annotation."})
    public boolean noGeneFeature = false;
}

