/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.pipeline;

import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.annotation.database.IntervalDatabaseDescription;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Pipeline;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.file.Channel;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.task.CommonDatabaseAnnotationTask;
import edu.sysu.pmglab.kgga.command.task.ExpDBAnnotationTask;
import edu.sysu.pmglab.kgga.command.task.FreqDBAnnotationTask;
import edu.sysu.pmglab.kgga.command.task.GeneFeatureAnnotationTask;
import edu.sysu.pmglab.kgga.command.task.SummarizeGeneIDSubRegionLengthTask;
import java.io.File;
import java.io.IOException;

public class AnnotationPipeline
extends Pipeline.Builder {
    public AnnotationPipeline(AnnotationOptions annotationOptions, File workspace, int threadNum) throws IOException {
        boolean annotateGeneFeature;
        boolean forceNotFilterByFreq = false;
        this.add((status, context) -> {
            if (context.get("AnnotationBaseVariantSet") == null) {
                throw new RuntimeException("Missing input file for annotation.");
            }
            File baseVarFile = (File)context.cast("AnnotationBaseVariantSet");
            GTBManager manager = new GTBManager(baseVarFile);
            if (manager.numOfVariants() < 1000L) {
                Channel.addChannel("https://idc.biosino.org/pmglab/resource/kgg/kgga/resources/");
            }
        });
        if (annotationOptions.freqDatabase != null && !annotationOptions.freqDatabase.isEmpty()) {
            this.add(new FreqDBAnnotationTask(annotationOptions, workspace, forceNotFilterByFreq, true, threadNum));
        }
        if (annotationOptions.expDatabase != null && !annotationOptions.expDatabase.isEmpty()) {
            this.add(new ExpDBAnnotationTask(annotationOptions, workspace, true, threadNum));
        }
        if (!(annotateGeneFeature = annotationOptions.noGeneFeature)) {
            this.add(new GeneFeatureAnnotationTask(annotationOptions, threadNum, workspace, true));
            this.add(new SummarizeGeneIDSubRegionLengthTask(annotationOptions, threadNum));
        }
        List<DatabaseDescription> databaseDescriptions = annotationOptions.varAnnotDatabase;
        List<IntervalDatabaseDescription> epigeneDatabaseDescriptions = annotationOptions.epigeneAnnotDatabase;
        if (databaseDescriptions != null && !databaseDescriptions.isEmpty() || epigeneDatabaseDescriptions != null && !epigeneDatabaseDescriptions.isEmpty()) {
            this.add(new CommonDatabaseAnnotationTask(annotationOptions, workspace, true, threadNum));
        }
    }

    public AnnotationPipeline(AnnotationOptions annotationOptions, File workspace, boolean toSummarizeGeneIDSubRegionLength, boolean forceNotFilterByFreq, int threadNum) throws IOException {
        boolean annotateGeneFeature;
        this.add((status, context) -> {
            if (context.get("AnnotationBaseVariantSet") == null) {
                throw new RuntimeException("Missing input file for annotation.");
            }
        });
        if (annotationOptions.freqDatabase != null && !annotationOptions.freqDatabase.isEmpty()) {
            this.add(new FreqDBAnnotationTask(annotationOptions, workspace, forceNotFilterByFreq, true, threadNum));
        }
        if (annotationOptions.expDatabase != null && !annotationOptions.expDatabase.isEmpty()) {
            this.add(new ExpDBAnnotationTask(annotationOptions, workspace, true, threadNum));
        }
        if (!(annotateGeneFeature = annotationOptions.noGeneFeature)) {
            this.add(new GeneFeatureAnnotationTask(annotationOptions, threadNum, workspace, true));
            if (toSummarizeGeneIDSubRegionLength) {
                this.add(new SummarizeGeneIDSubRegionLengthTask(annotationOptions, threadNum));
            }
        }
        this.add(new CommonDatabaseAnnotationTask(annotationOptions, workspace, true, threadNum));
    }
}

