/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.pipeline;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.rule.CountRule;
import edu.sysu.pmglab.commandParser.rule.IRule;
import edu.sysu.pmglab.commandParser.validator.range.Double_0_1_RangeValidator;
import edu.sysu.pmglab.commandParser.validator.range.Float_0_1_RangeValidator;
import edu.sysu.pmglab.commandParser.validator.range.Float_0_RangeValidator;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.coordinate.RefGenomeVersion;
import edu.sysu.pmglab.kgga.command.setting.GlobalAnnotationGenomeVersion;
import edu.sysu.pmglab.kgga.command.setting.GwasSumFileOption;
import edu.sysu.pmglab.kgga.command.setting.OutputTypeConverter;
import edu.sysu.pmglab.kgga.command.setting.ToolOptionsSet;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.io.InputPhenotypeFileSet;
import edu.sysu.pmglab.kgga.io.InputType;
import java.io.File;

public class GeneralIOOptions {
    @DynamicOption(names={"--input-gty-file", "-i"}, args={"file", "type=AUTO", "refG=hg38", "include=", "exclude="}, required=true, repeated=true, converter=VariantFileMeta.Converter.class)
    @OptionUsage(format="--input-gty-file file [type=AUTO/VCF/GTB/MAF] [refG=hg18/hg19/hg38]", defaultTo="<file> type=AUTO refG=hg38", description={""})
    public List<VariantFileMeta> inputGTYFiles = new List();
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32)
    @OptionUsage(format="--threads <int>", group="General settings")
    public int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--rand-seed", "-r"}, type=FieldType.varInt64)
    @OptionUsage(format="--rand-seed <int>", group="General settings")
    public long randomSeed = 0L;
    @DynamicOption(names={"--sum-file", "-sf"}, args={"file", "cp12Cols=", "pbsCols=", "r12Cols=", "freqA1Col=", "sampleSizeCols=", "r2Col=", "refG=hg38", "type=AUTO", "sep=", "betaType=", "prevalence=", "exclude=", "genomicControl=", "missingTag=."}, repeated=true, converter=GwasSumFileOption.Converter.class)
    @OptionUsage(format="---sum-file file [cp12Cols=CHR,POS,...] [pbsCols=P,BETA,SE][type=AUTO/VCF/GTB/TSV] [refG=hg18/hg19/hg38] [sep=] [sampleSizeCols=xxx] [betaType=1]  [prevalence=0.01] [exclude=chr6:23~3233;chr6:23345545,545554~444555545]", defaultTo="<file> cp12Cols=CHR,POS,A1,A2 refG=hg38", description={""})
    public List<GwasSumFileOption> gwasSumFileOptions;
    @Option(names={"--annotation-genome-version"}, type=FieldType.string)
    @OptionUsage(defaultTo="hg38", group="General settings", format="--annotation-genome-version <hg38> ", description={"Set the reference genome of annotated and output variants. \nIt is hg38. Note: this can only be modified by developers."})
    public RefGenomeVersion globalAnnotationGenomeVersion = RefGenomeVersion.hg38;
    @Option(names={"--output", "-o"}, type=FieldType.file)
    @OptionUsage(group="General settings", format="--output <dir>", defaultTo="./kgga", description={"Specify the output folder path."})
    public File output = new File(RuntimeProperty.WORKSPACE_PATH, "kgga");
    @CustomOption(names={"--output-gty-format", "-ogf"}, converter=OutputTypeConverter.class)
    @OptionUsage(group="General settings", description={"Specify the output format for genotype data."}, item={@UsageItem(key="Default", value={"GTB"})})
    public InputType outputGtyFormat = null;
    @DynamicOption(names={"--plink"}, args={"options", "path=./tools/plink2", "gtyFormat=PLINK_BED"}, converter=ToolOptionsSet.Converter.class)
    @OptionUsage(group="Launch PLINK Options", format="--plink <plink options except for file path of input genotypes and output path> ", description={"Specify PLINK's options for follow-up analysis of output genotypes by plink\nBy default this function is inactivated."})
    public ToolOptionsSet plinkOptionsSet;
    @DynamicOption(names={"--plink2"}, args={"options", "path=./tools/plink2", "gtyFormat=PLINK_PGEN"}, converter=ToolOptionsSet.Converter.class)
    @OptionUsage(group="Launch PLINK2 Options", format="--plink2 <plink options except for file path of input genotypes and output path> ", description={"Specify PLINK's options for follow-up analysis of output genotypes by plink\nBy default this function is inactivated."})
    public ToolOptionsSet plink2OptionsSet;
    @DynamicOption(names={"--gcta"}, args={"options", "path=./tools/gcta64", "gtyFormat=PLINK_BED"}, converter=ToolOptionsSet.Converter.class)
    @OptionUsage(group="Launch GCTA Options", format="--gcta <GCTA options except for file path of input genotypes and output path> ", description={"Specify GCTA's options for follow-up analysis of output genotypes by GCTA\nBy default this function is inactivated."})
    public ToolOptionsSet gctaOptionsSet;
    @Option(names={"--show-gty-qc-metrics", "-sgqm"}, type=FieldType.NULL)
    @OptionUsage(group="Quality Control Options", format="--show-gty-qc-metrics", description={"Show detailed QC metrics at genotype level. Note this option may decrease the speed in parallel computing because of thread synchronizing."})
    public boolean showGTY_QCMetrics = false;
    @DynamicOption(names={"--ped-file"}, args={"file", "pheno=", "covar=", "composite=n", "missing=-9"}, required=false, converter=InputPhenotypeFileSet.Converter.class)
    @OptionUsage(group="Phenotype Setting Options", format="--ped-file file [pheno=columnName] [covar=columnName2,columnName2,...] [composite=y/n] [missing=missingLabel]", defaultTo="<path/to/file>", description={"Specify the path of a pedigree file with phenotypes.The the column names in the pedigree file can be specified for major phenotype and co-variate phenotype(s)."})
    public InputPhenotypeFileSet phenoFileSet = null;
    @Option(names={"--only-snv"}, type=FieldType.NULL)
    @OptionUsage(group="Mutation Type Filtration Options", format="--only-snv", description={"Only single nucleotide variants are retained."})
    public boolean onlySnp = false;
    @Option(names={"--only-indel"}, type=FieldType.NULL)
    @OptionUsage(group="Mutation Type Filtration Options", format="--only-indel", description={"Only small insertion or deletion (InDel, <=50 bp) variants are retained."})
    public boolean onlyIndel = false;
    final String freqQCGroupName = "Allele Frequency Filtration Options";
    final String missingGenotypesQCGroupName = "Missing Genotypes Filtration Options";
    final String hweQCGroupName = "Hardy-Weinberg Equilibrium Filtration Options";
    @Option(names={"--local-af"}, type=FieldType.floatInterval)
    @OptionUsage(group="Allele Frequency Filtration Options", format="--local-af <min>~<max>", description={"Exclude variants in all subjects with alternative allele frequency (AF) outside the range [min, max]."})
    public FloatInterval localAf = null;
    @Option(names={"--local-min-ac"}, type=FieldType.floatInterval)
    @OptionUsage(group="Allele Frequency Filtration Options", format="--local-af <min>~<max>", description={"Exclude variants in all subjects with alternative allele frequency (AF) outside the range [min, max]."})
    public Integer localAltCount = 1;
    @Option(names={"--local-af-case"}, type=FieldType.floatInterval)
    @OptionUsage(group="Allele Frequency Filtration Options", format="--local-af-case <min>~<max>", description={"Exclude variants in cases with alternative allele frequency (AF) outside the range [min, max]."})
    public FloatInterval localAfCase = null;
    @Option(names={"--local-af-control"}, type=FieldType.floatInterval)
    @OptionUsage(group="Allele Frequency Filtration Options", format="--local-af-control <min>~<max>", description={"Exclude variants in controls with alternative allele frequency (AF) outside the range [min, max]."})
    public FloatInterval localAfControl = null;
    @Option(names={"--min-case-control-af-ratio"}, type=FieldType.float32, validator=Float_0_RangeValidator.class)
    @OptionUsage(group="Allele Frequency Filtration Options", format="--min-case-control-af-ratio <float>", description={"Exclude variants at which the alternative allele frequency (AF) in cases is less than that of in controls multiplied by a specified ratio."})
    public Float minCaseControlAfRatio = null;
    @Option(names={"--local-maf"}, type=FieldType.floatInterval)
    @OptionUsage(group="Allele Frequency Filtration Options", format="--local-maf <min>~<max>", description={"Exclude variants in all subjects with minor allele frequency (MAF) outside the range [min, max]."})
    public FloatInterval localMaf = null;
    @Option(names={"--local-maf-case"}, type=FieldType.floatInterval)
    @OptionUsage(group="Allele Frequency Filtration Options", format="--local-maf-case <min>~<max>", description={"Exclude variants in cases with minor allele frequency (MAF) outside the range [min, max]."})
    public FloatInterval localMafCase = null;
    @Option(names={"--local-maf-control"}, type=FieldType.floatInterval)
    @OptionUsage(group="Allele Frequency Filtration Options", format="--local-maf-control <min>~<max>", description={"Exclude variants in controls with minor allele frequency (MAF) outside the range [min, max]."})
    public FloatInterval localMafControl = null;
    @Option(names={"--min-case-control-maf-ratio"}, type=FieldType.float32, validator=Float_0_RangeValidator.class)
    @OptionUsage(group="Allele Frequency Filtration Options", format="--min-case-control-maf-ratio <float>", description={"Exclude variants at which the minor allele frequency (MAF) in cases is less than that of in controls multiplied by a specified ratio."})
    public Float minCaseControlMafRatio = null;
    @Option(names={"--min-obs-rate"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class)
    @OptionUsage(group="Missing Genotypes Filtration Options", defaultTo="0", format="--min-obs-rate <float>", description={"Exclude variants in all subjects with the observed rate of non-missing genotypes < minObsRate (e.g. 0.8)."})
    public Float minObsRate = null;
    @Option(names={"--min-obs-rate-case"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class)
    @OptionUsage(group="Missing Genotypes Filtration Options", format="--min-obs-rate-case <float>", description={"Exclude variants in cases with the observed rate of non-missing genotypes < minObsRate (e.g. 0.8)."})
    public Float minObsRateCase = null;
    @Option(names={"--min-obs-rate-control"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class)
    @OptionUsage(group="Missing Genotypes Filtration Options", format="--min-obs-rate-control <float>", description={"Exclude variants in controls with the observed rate of non-missing genotypes < minObsRate (e.g. 0.8)."})
    public Float minObsRateControl = null;
    @Option(names={"--hwe"}, type=FieldType.float64, validator=Double_0_1_RangeValidator.class)
    @OptionUsage(group="Hardy-Weinberg Equilibrium Filtration Options", format="--hwe <double>", description={"Exclude variants in all subjects with the Hardy-Weinberg test p value <= pThreshold (e.g. 1E-5)."})
    public Double hwe = null;
    @Option(names={"--hwe-case"}, type=FieldType.float64, validator=Double_0_1_RangeValidator.class)
    @OptionUsage(group="Hardy-Weinberg Equilibrium Filtration Options", format="--hwe-case <double>", description={"Exclude variants in cases with the Hardy-Weinberg test p value <= pThreshold (e.g. 1E-5)."})
    public Double hweCase = null;
    @Option(names={"--hwe-control"}, type=FieldType.float64, validator=Double_0_1_RangeValidator.class)
    @OptionUsage(group="Hardy-Weinberg Equilibrium Filtration Options", format="--hwe-control <double>", description={"Exclude variants in controls with the Hardy-Weinberg test p value <= pThreshold (e.g. 1E-5)."})
    public Double hweControl = null;

    public GeneralIOOptions() {
        GlobalAnnotationGenomeVersion.setRefGenomeVersion(this.globalAnnotationGenomeVersion);
    }

    public static class GeneralIOOptionsRule
    implements IRule {
        final List<IRule> rules = new List();

        public GeneralIOOptionsRule() {
            this.rules.add(new CountRule(count -> count <= 1, "--local-af", "--local-maf"));
            this.rules.add(new CountRule(count -> count <= 1, "--local-af-case", "--local-maf-case"));
            this.rules.add(new CountRule(count -> count <= 1, "--local-af-control", "--local-maf-control"));
        }

        public String toString() {
            return "The option '--local-af[-case/-control]' cannot be used together with '--local-maf[-case/-control]'";
        }

        @Override
        public boolean filter(CommandOptions commandOptions) {
            for (IRule rule : this.rules) {
                if (rule.filter(commandOptions)) continue;
                return false;
            }
            return true;
        }
    }
}

