/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.pipeline;

import edu.sysu.pmglab.annotation.database.DataBaseFactory;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.MutationCountAnalysisOptions;
import edu.sysu.pmglab.kgga.command.pipeline.ProcessBackgroundMutationPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.AFGRESetting;
import edu.sysu.pmglab.kgga.command.setting.CountRegressionMCVSSetting;
import edu.sysu.pmglab.kgga.command.setting.CountRegressionRunnerSetting;
import edu.sysu.pmglab.kgga.command.setting.GeneSetAssocSetting;
import edu.sysu.pmglab.kgga.command.setting.InteractionSetting;
import edu.sysu.pmglab.kgga.command.task.AFGRETask;
import edu.sysu.pmglab.kgga.command.task.AdjustPopulationAlleleFreqTask;
import edu.sysu.pmglab.kgga.command.task.AppendMutationSubjectIDTask;
import edu.sysu.pmglab.kgga.command.task.AssignVar2GeneTask;
import edu.sysu.pmglab.kgga.command.task.GeneSetAssocTask;
import edu.sysu.pmglab.kgga.command.task.GenerateReferenceAFGRETask;
import edu.sysu.pmglab.kgga.command.task.GenerateReferenceGeneFreqScoreTask;
import edu.sysu.pmglab.kgga.command.task.MergeVariantScoresTask;
import edu.sysu.pmglab.kgga.command.task.MutationCountRegressionTask;
import edu.sysu.pmglab.kgga.command.task.OutputVariants2TSVTask;
import edu.sysu.pmglab.kgga.command.task.PubMedSearchTask;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.stat.DynamicScanWindows;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class MutationCountAdjustPipeline
extends Enum<MutationCountAdjustPipeline> {
    public static final /* enum */ MutationCountAdjustPipeline INSTANCE = new MutationCountAdjustPipeline();
    private static final /* synthetic */ MutationCountAdjustPipeline[] $VALUES;

    public static MutationCountAdjustPipeline[] values() {
        return (MutationCountAdjustPipeline[])$VALUES.clone();
    }

    public static MutationCountAdjustPipeline valueOf(String name) {
        return Enum.valueOf(MutationCountAdjustPipeline.class, name);
    }

    public void variableScannedRegionExecutor(GeneralIOOptions inputsOptions, AnnotationOptions annotationOptions, MutationCountAnalysisOptions mutationCountAnalysisOptions, Executor mainExecutor, File mainWorkspace) throws Exception {
        DynamicScanWindows dynamicScanWindows = DynamicScanWindows.getInstance();
        dynamicScanWindows.setRServer(mutationCountAnalysisOptions.rServer);
        dynamicScanWindows.setLengthThreshold(mutationCountAnalysisOptions.countRegressionVSRSetting.unitLenThreshold);
        dynamicScanWindows.setVariantSizeThreshold(mutationCountAnalysisOptions.countRegressionVSRSetting.unitSizeThreshold);
        dynamicScanWindows.setFDRCutoff(mutationCountAnalysisOptions.countRegressionVSRSetting.pValueInRegion);
        dynamicScanWindows.setVarInRegion(mutationCountAnalysisOptions.countRegressionVSRSetting.variantInRegion);
        dynamicScanWindows.setWindowLength(mutationCountAnalysisOptions.countRegressionVSRSetting.lengthInRegion);
        dynamicScanWindows.setRatio(mutationCountAnalysisOptions.countRegressionVSRSetting.overlappedProportion);
        dynamicScanWindows.setTestType("RankSum");
        dynamicScanWindows.useFDRCorrection(true);
        List<String> freqFields4Regression = new List<String>();
        CountRegressionMCVSSetting countRegressionMCVSSetting = mutationCountAnalysisOptions.countRegressionVSRSetting;
        String[] regressionFeatureNames = countRegressionMCVSSetting.getPredictorFields();
        String[] countWeightingScores = countRegressionMCVSSetting.getWeightFields();
        List<String> wight4Regression = new List<String>();
        wight4Regression.addAll(countWeightingScores);
        boolean stepwise = false;
        List<DatabaseDescription> freqDatabase = annotationOptions.freqDatabase;
        for (DatabaseDescription descriptions : freqDatabase) {
            freqFields4Regression.addAll(descriptions.getFields());
        }
        boolean adjustAF = true;
        mainExecutor.addTask(new AppendMutationSubjectIDTask(inputsOptions, mainWorkspace, true, adjustAF, freqFields4Regression));
        mainExecutor.addTask(new AdjustPopulationAlleleFreqTask(inputsOptions, mainWorkspace, true, freqFields4Regression));
        mainExecutor.execute();
        mainExecutor.clearTasks();
        mainExecutor.addTask(new OutputVariants2TSVTask(mainWorkspace, inputsOptions.threads));
        mainExecutor.addTask(new AssignVar2GeneTask(annotationOptions, mainWorkspace, true, inputsOptions.threads));
        mainExecutor.execute();
        mainExecutor.clearTasks();
        mainExecutor.addTask(new MutationCountRegressionTask(inputsOptions, annotationOptions, mutationCountAnalysisOptions, mainWorkspace, regressionFeatureNames, wight4Regression, freqFields4Regression, null, stepwise, true, adjustAF));
        mainExecutor.execute();
        mainExecutor.clearTasks();
    }

    public void geneSetAssocExecutor(GeneralIOOptions inputsOptions, AnnotationOptions annotationOptions, MutationCountAnalysisOptions mutationCountAnalysisOptions, Executor mainExecutor, File mainWorkspace) throws Exception {
        String[] scoresToBeMerged;
        boolean isCombine;
        List freqFields4Regression = new List();
        GeneSetAssocSetting geneSetAssocSetting = mutationCountAnalysisOptions.geneSetAssocSetting;
        List<DatabaseDescription> freqDatabase = annotationOptions.freqDatabase;
        if (freqFields4Regression.isEmpty()) {
            if (freqDatabase == null || freqDatabase.isEmpty()) {
                throw new RuntimeException("No background allelic frequency reference databases are set!");
            }
            for (DatabaseDescription databaseDescription : freqDatabase) {
                Database<?, Variant> database = DataBaseFactory.instanceOf(databaseDescription);
                freqFields4Regression.addAll(List.wrap(database.getAllFieldNames()));
            }
        }
        if ((isCombine = geneSetAssocSetting.isCombine()) && (scoresToBeMerged = geneSetAssocSetting.getWeightFields()).length > 1 && !scoresToBeMerged[0].equalsIgnoreCase("@AFGRE")) {
            THashMap<String, String[]> groupedFieldMap = new THashMap<String, String[]>();
            groupedFieldMap.put("MutationScore", scoresToBeMerged);
            mainExecutor.addTask(new MergeVariantScoresTask(mainWorkspace, groupedFieldMap, true, inputsOptions.threads));
        }
        mainExecutor.addTask(new AppendMutationSubjectIDTask(inputsOptions, mainWorkspace, true));
        mainExecutor.addTask(new OutputVariants2TSVTask(mainWorkspace, inputsOptions.threads));
        mainExecutor.addTask(new AssignVar2GeneTask(annotationOptions, mainWorkspace, true, inputsOptions.threads));
        mainExecutor.addTask(new GeneSetAssocTask(inputsOptions, annotationOptions, mutationCountAnalysisOptions, mainWorkspace, true));
        mainExecutor.execute();
        mainExecutor.clearTasks();
    }

    public void afgreAndRunnerExecutor(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, AnnotationOptions annotationOptions, MutationCountAnalysisOptions mutationCountAnalysisOptions, Executor mainExecutor, File mainWorkspace) throws Exception {
        List<String> freqFields4Regression = new List<String>();
        List<String> scoreFields4Regression = new List<String>();
        AFGRESetting afgre = mutationCountAnalysisOptions.afgre;
        CountRegressionRunnerSetting regressionSetting = mutationCountAnalysisOptions.countRegressionRunnerSetting;
        InteractionSetting interactionSetting = mutationCountAnalysisOptions.interactionSetting;
        boolean toCalcAFGRE = afgre != null;
        boolean toPerformFreqBasedRegression = regressionSetting != null;
        File generateReferenceGeneFreqScoreTaskPath = null;
        HashMap<String, String[]> mergedFields = new HashMap<String, String[]>();
        if (toCalcAFGRE) {
            Executor subExecutor = ProcessBackgroundMutationPipeline.INSTANCE.generateBackgroundFrequencies(inputsOptions, vcfQualityControlOptions, annotationOptions, mutationCountAnalysisOptions, mainExecutor, mainWorkspace, scoreFields4Regression, freqFields4Regression);
            File generateReferenceAFGRETaskPath = (File)subExecutor.getParam(GenerateReferenceAFGRETask.class);
            generateReferenceGeneFreqScoreTaskPath = (File)subExecutor.getParam(GenerateReferenceGeneFreqScoreTask.class);
            if (toCalcAFGRE) {
                Object groupedAFGREFieldMap;
                Boolean updatedGReferenceSet = (Boolean)subExecutor.getParam("UpdatedBaseGeneSet");
                mainExecutor.addTask(new AFGRETask(annotationOptions, mainWorkspace, generateReferenceAFGRETaskPath, updatedGReferenceSet, afgre, null, true, inputsOptions.threads));
                mainExecutor.execute();
                mainExecutor.clearTasks();
                if (afgre.getFields().length > 1 && afgre.isCombine() && (groupedAFGREFieldMap = (Map)mainExecutor.getParam("GroupedAFGREFieldMapForCombine")) != null) {
                    mergedFields.putAll((Map<String, String[]>)groupedAFGREFieldMap);
                    mainExecutor.addTask(new MergeVariantScoresTask(mainWorkspace, mergedFields, true, inputsOptions.threads));
                }
                mainExecutor.execute();
                mainExecutor.clearTasks();
            }
        }
        assert (regressionSetting != null);
        String[] scoresToBeMerged = regressionSetting.getWeightFields();
        if (scoresToBeMerged.length > 0 && !scoresToBeMerged[0].equalsIgnoreCase("@AFGRE")) {
            if (regressionSetting.isCombine() && scoresToBeMerged.length > 1) {
                mergedFields.put("MutationScore", scoresToBeMerged);
                mainExecutor.addTask(new MergeVariantScoresTask(mainWorkspace, mergedFields, true, inputsOptions.threads));
                scoreFields4Regression.add("Combined@MutationScore");
            } else {
                String[] mutationCountWeightScores = regressionSetting.getWeightFields();
                scoreFields4Regression.addAll((String[])mutationCountWeightScores);
            }
        }
        if (freqFields4Regression.isEmpty()) {
            List<DatabaseDescription> databaseDescriptions = annotationOptions.freqDatabase;
            if (databaseDescriptions == null || databaseDescriptions.isEmpty()) {
                throw new RuntimeException("No background allelic frequency reference databases are set!");
            }
            for (DatabaseDescription databaseDescription : databaseDescriptions) {
                Database<?, Variant> database = DataBaseFactory.instanceOf(databaseDescription);
                freqFields4Regression.addAll(List.wrap(database.getAllFieldNames()));
            }
        }
        if (toPerformFreqBasedRegression) {
            mainExecutor.addTask(new AppendMutationSubjectIDTask(inputsOptions, mainWorkspace, true));
        }
        mainExecutor.addTask(new OutputVariants2TSVTask(inputsOptions, mainWorkspace, null, true));
        if (toPerformFreqBasedRegression) {
            mainExecutor.addTask(new AssignVar2GeneTask(annotationOptions, mainWorkspace, true, inputsOptions.threads));
            int minIndiv = 10;
            boolean stepwise = false;
            if (GlobalPedIndividuals.size() < minIndiv) {
                throw new Exception("No regression is performed because the number of patients is less " + minIndiv + ".");
            }
            String[] regressionFeatureNames = regressionSetting.getPredictorFields();
            if (regressionSetting.getWeightFields().length > 0) {
                mainExecutor.addTask(new MutationCountRegressionTask(inputsOptions, annotationOptions, mutationCountAnalysisOptions, interactionSetting, mainWorkspace, regressionFeatureNames, scoreFields4Regression, freqFields4Regression, generateReferenceGeneFreqScoreTaskPath, stepwise, true));
            } else {
                mainExecutor.addTask(new MutationCountRegressionTask(inputsOptions, annotationOptions, mutationCountAnalysisOptions, interactionSetting, mainWorkspace, regressionFeatureNames, null, freqFields4Regression, generateReferenceGeneFreqScoreTaskPath, stepwise, true));
            }
            mainExecutor.execute();
            mainExecutor.clearTasks();
            mainExecutor.addTask(new PubMedSearchTask(mainWorkspace, true, mutationCountAnalysisOptions.pubmedMining));
        }
        mainExecutor.execute();
        mainExecutor.clearTasks();
    }

    static {
        $VALUES = new MutationCountAdjustPipeline[]{INSTANCE};
    }
}

