/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.pipeline;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.kgga.command.setting.AFGRESetting;
import edu.sysu.pmglab.kgga.command.setting.CountRegressionMCVSSetting;
import edu.sysu.pmglab.kgga.command.setting.CountRegressionRunnerSetting;
import edu.sysu.pmglab.kgga.command.setting.GeneSetAssocSetting;
import edu.sysu.pmglab.kgga.command.setting.InteractionSetting;
import edu.sysu.pmglab.kgga.command.setting.PubMedFieldsSet;
import edu.sysu.pmglab.kgga.command.setting.RConnectValidator;
import java.net.InetSocketAddress;

public class MutationCountAnalysisOptions {
    final String freqPrioritizationGroupName = "Frequency-based prioritization of variants and genes";
    final String envSettingGroupName = "Environment Setting Options";
    @DynamicOption(names={"--gene-set-assoc"}, args={"file=", "weight=", "combineWeight=y", "threshold=", "hasHead=y", "sep=TAB", "idIndex=0", "urlIndex=1", "geneStartIndex=2"}, converter=GeneSetAssocSetting.Converter.class)
    @OptionUsage(group="Mutation count regression in preset regions", format="--gene-set-assoc file [weight=<field3>,<field4>] [adjustMethod=predictor/subtract] [combine=y/n][countOnce=y/n] [containRef=y/n]", description={"Set the regression setting by a negative-binomial (NTB) regression on mutation counts.\npredictor: the fields of databases used as predictors for mutation counts for TNB regression. When no fields are specified, mutation counts will be regressed on fixed predictors e.g., region length.\nweight: the fields of databases used as weights for mutation counts for TNB regression. When it is @AFGRE, the recalibrated weights will be used as weights.\nadjustMethod: the method [predictor/subtract] to adjust local mutation counts by count in reference population. It is predict by default.\ncombineWeight: whether to combine the specified scores (if available) before weighting the mutation counts. It is yes by default.\ncountOnce: only keep the most influential variant if a subject has multiple variants in region or gene. It is yes by default.\ncontrolPredictor: whether to use the weighted mutation burden of control as an independent variable."})
    public GeneSetAssocSetting geneSetAssocSetting;
    @DynamicOption(names={"--runner"}, args={"predictor=", "weight=", "adjustMethod=full", "combineWeight=y", "countOnce=y", "controlPredictor=n", "freqRatio=3"}, converter=CountRegressionRunnerSetting.Converter.class)
    @OptionUsage(group="Mutation count regression in preset regions", format="--runner <field1>,<field2> [weight=<field3>,<field4>] [adjustMethod=full/cut] [combine=y/n][countOnce=y/n] [containRef=y/n]", description={"Set the regression setting by a negative-binomial (NTB) regression on mutation counts.\npredictor: the fields of databases used as predictors for mutation counts for TNB regression. When no fields are specified, mutation counts will be regressed on fixed predictors e.g., region length.\nweight: the fields of databases used as weights for mutation counts for TNB regression. When it is @AFGRE, the recalibrated weights will be used as weights.\nadjustMethod: the method [full/cut] to adjust local mutation counts by weights. It is full by default.\ncombineWeight: whether to combine the specified scores (if available) before weighting the mutation counts. It is yes by default.\ncountOnce: only keep the most influential variant if a subject has multiple variants in region or gene. It is yes by default.\ncontrolPredictor: whether to use the weighted mutation burden of control as an independent variable.\nfreqRatio: exclude variants where the ratio of the alternative allele frequency (AF) in cases to controls falls outside the range of [value] to 1/[value]. This filtering step retains variants exhibiting substantial allelic frequency differences between cases and controls the value is large.The value 1 leads to no filtering."})
    public CountRegressionRunnerSetting countRegressionRunnerSetting;
    @DynamicOption(names={"--interaction"}, args={"file=", "threshold=", "hasHead=y", "sep=TAB"}, converter=InteractionSetting.Converter.class)
    @OptionUsage(group="Regression analysis of mutation counts in interactions within predefined regions, utilized in conjunction with the runner parameter set.", format="--interaction file=<path> threshold=<float> [hasHead=y/n] [sep=TAB/COMMA/SEMICOLON/BLANK]", description={"Configures parameters for gene interaction analysis to integrate gene regions.\nfile: specify the annotation file for gene interactions. Each line should be of the form: gene1,gene2,....,interactionScore.\nthreshold: gene combinations smaller than the threshold will be excluded.\nhasHead: whether the file has a header.\nsep: specify the separator for each line and select from these options: [TAB/COMMA/SEMICOLON/BLANK]."})
    public InteractionSetting interactionSetting;
    @Option(names={"--min-count"}, type=FieldType.int32)
    @OptionUsage(group="Frequency-based prioritization of variants and genes", defaultTo="2", format="--min-count <int>", description={"Set the minimal mutation count in a region for regression."})
    public int minCount = 2;
    @DynamicOption(names={"--afgre"}, args={"field", "scale=10,100,1000", "combine=y"}, converter=AFGRESetting.Converter.class)
    @OptionUsage(group="Recalibrate variants' deleterious predictions scores of variants by AFGRE", format="--afgre <fieldGroup1@field1>,<fieldGroup2@field2>,... [scale=<int>,<int>,<int>] [combine=y/n]", description={"Set the fields of databases to be recalibrated by AFGRE, which are followed by scales and an indicator (combine) of combining multiple scores.\n                    The scale values are 10,100,1000 by default; 0 means no recalibration.\n                    The combination value is 'y' by default; 'n' means no combination."})
    public AFGRESetting afgre;
    @DynamicOption(names={"--pubmed-mining"}, args={"keywords", "field=Title/Abstract"}, converter=PubMedFieldsSet.Converter.class)
    @OptionUsage(group="Auxiliary Function Options", format="--pubmed-mining disease+name1,disease+name2 [field=Title/Abstract]", description={"Specify keywords of phenotypes and query field type to allow KGGA to link prioritized genes with the phenotypes by papers in PubMed database.\nBy default this function is inactivated. If it is activated, the field is 'Title/Abstract' by default. Another field is 'Text+Word'"})
    public PubMedFieldsSet pubmedMining;
    @DynamicOption(names={"--mcvs"}, args={"predictor=", "weight=", "adjustMethod=cut", "combine=y", "countOnce=y", "lengthThreshold=10000", "scanRegionLength=1500,2000,2500,3000", "scanRegionSize=10,20,30,40,50", "pValueInRegion=0.25", "sizeThreshold=50", "overlappedProportion=0.6", "scanBySize=y"}, converter=CountRegressionMCVSSetting.Converter.class)
    @OptionUsage(group="Mutation count regression in variable scanned regions", format="--mcvs predictor=<field1>,<field2> [weight=<field3>,<field4>] [adjustMethod=full/cut] [combine=y/n] [countOnce=y/n] [lengthThreshold=<int>] [scanRegionLength=<int>,<int>,<int>] [scanRegionSize=<int>,<int>,<int>] [pValueInRegion=<float>] [sizeThreshold=<int>] [overlappedProportion=float] [scanBySize=y/n]", description={"Set the regression setting by a negative-binomial (NTB) regression on mutation counts.\npredictor: the fields of databases used as predictors for mutation counts for TNB regression. When no fields are specified, mutation counts will be regressed on fixed predictors e.g., region length.\nweight: the fields of databases used as weights for mutation counts for TNB regression. When it is @AFGRE, the recalibrated weights will be used as weights.\nadjustMethod: the method [full/cut] to adjust local mutation counts by weights. It is cut by default.\ncombine: to combine the specified scores (if available) before weighting the mutation counts. It is yes by default.\ncountOnce: only keep the most influential variant if a subject has multiple variants in region or gene. It is yes by default."})
    public CountRegressionMCVSSetting countRegressionVSRSetting;
    @Option(names={"--r-server"}, type=FieldType.ipsocket, validator=RConnectValidator.class)
    @OptionUsage(group="Environment Setting Options", format="--r-server host_ip:host_port", description={"Set the address and port number of the R Server."})
    public InetSocketAddress rServer = new InetSocketAddress("localhost", 6300);
}

