/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.pipeline;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.Variant2Variant;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.command.task.CaseControlSummaryQCTask;
import edu.sysu.pmglab.kgga.command.task.ConvertMAF2GTBTask;
import edu.sysu.pmglab.kgga.command.task.ConvertVCF2GTBTask;
import edu.sysu.pmglab.kgga.command.task.GenerateAnnotationBaseNoGtyTask;
import edu.sysu.pmglab.kgga.command.task.GenerateAnnotationBaseTask;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public enum PreprocessingPipeline {
    INSTANCE;

    private GTBManager annotationBaseGTB;

    public GTBManager generateAnnotationBase(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, Executor workflow, File workspace) throws IOException {
        boolean isBinaryPhenotype;
        AtomicInteger newlyGeneratedBaseFileNum = new AtomicInteger(0);
        long varNum = 0L;
        if (this.annotationBaseGTB == null) {
            List<GTBManager> managers = new List<GTBManager>();
            List<File> generatedGtyFiles = new List<File>();
            List<VariantFileMeta> originalInputs = inputsOptions.inputGTYFiles;
            int fileID = -2;
            int fileNum = 0;
            for (VariantFileMeta orgInput : originalInputs) {
                fileNum += orgInput.inputFiles.size();
            }
            if (fileNum > 1) {
                fileID = -1;
            }
            for (VariantFileMeta orgInput : originalInputs) {
                for (LiveFile file : orgInput.inputFiles) {
                    VariantFileMeta processedMeta = orgInput.noInputFileClone(file);
                    this.generate(inputsOptions, vcfQualityControlOptions, processedMeta, workflow, workspace, managers, generatedGtyFiles, ++fileID, newlyGeneratedBaseFileNum);
                }
            }
            workflow.clearTasks();
            if (managers.isEmpty()) {
                throw new FileNotFoundException();
            }
            if (managers.size() <= 1) {
                this.annotationBaseGTB = (GTBManager)managers.get(0);
            } else {
                File mergedFile;
                Optional cachedFile;
                boolean forceUpdate = newlyGeneratedBaseFileNum.get() > 0;
                TaskTracker.TaskResult taskResult = new TaskTracker.TaskResult(((Object)((Object)this)).getClass().getName(), String.valueOf(managers.hashCode()), "MergedAnnotBase");
                Optional<Object> optional = cachedFile = forceUpdate ? Optional.empty() : SetupApplication.GlobalTaskTracker.checkTask(taskResult);
                if (cachedFile.isPresent()) {
                    mergedFile = (File)cachedFile.get();
                } else {
                    File outputAnnotFile = new File(FileUtils.getSubFile(workspace.getPath() + "/GenerateAnnotationBaseTask0/", InputOutputFileSet.getAnnotationFileName()));
                    Processor.setInputs(managers.apply(GTBInputOption::new)).setOutput(new GTBOutputOption(outputAnnotFile).dropDuplicateMeta(), (inputs, output) -> {
                        output.addFields(((GTBInputOption)inputs.fastGet(0)).getAllFields());
                        output.addMeta(((GTBInputOption)inputs.fastGet(0)).getMeta());
                    }).bridge(new Variant2Variant()).setListener(new InputOutputListener()).submit(inputsOptions.threads);
                    taskResult.setOutputPath(outputAnnotFile);
                    SetupApplication.GlobalTaskTracker.recordTaskCompletion(taskResult);
                    mergedFile = outputAnnotFile;
                }
                this.annotationBaseGTB = new GTBManager(mergedFile);
            }
            varNum = this.annotationBaseGTB.numOfVariants();
            workflow.getLogger().info("{} variants that passed variant filtration are stored in {}.", (Object)varNum, (Object)this.annotationBaseGTB.getFile().getPath());
        }
        if (isBinaryPhenotype = GlobalPedIndividuals.isBinaryPhenotypes(0)) {
            workflow.addTask(new CaseControlSummaryQCTask(this.annotationBaseGTB, inputsOptions, workspace, true));
            workflow.execute();
            workflow.clearTasks();
            this.annotationBaseGTB = new GTBManager((File)workflow.getParam("AnnotationBaseVariantSet"));
        }
        return this.annotationBaseGTB;
    }

    private void generate(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, VariantFileMeta processedVariantFileMeta, Executor workflow, File workspace, List<GTBManager> gtbManagers, List<File> gtyFiles, int fileID, AtomicInteger newlyGeneratedFileNum) throws IOException {
        boolean saveGTY = false;
        boolean showGTY_QCMetrics = false;
        if (inputsOptions != null) {
            saveGTY = inputsOptions.outputGtyFormat != null;
            showGTY_QCMetrics = inputsOptions.showGTY_QCMetrics;
        }
        switch (processedVariantFileMeta.type) {
            case MAF: {
                List<FieldMeta> reservedFields = new List<FieldMeta>();
                reservedFields.add(FieldMeta.of("GTYSUM@Tumor_Allele_Count", FieldType.varInt32));
                reservedFields.add(FieldMeta.of("GTYSUM@Tumor_Allele_SubID", FieldType.stringArray));
                workflow.addTask(new ConvertMAF2GTBTask(inputsOptions, processedVariantFileMeta, false, workspace, true));
                if (fileID < 0) {
                    workflow.addTask(new GenerateAnnotationBaseNoGtyTask(inputsOptions, vcfQualityControlOptions, workspace, reservedFields, processedVariantFileMeta.refG, true));
                } else {
                    workflow.addTask(new GenerateAnnotationBaseNoGtyTask(inputsOptions, vcfQualityControlOptions, workspace, reservedFields, processedVariantFileMeta.refG, true, fileID));
                }
                workflow.execute();
                workflow.clearTasks();
                gtbManagers.add((GTBManager)workflow.getParam("OutputManager"));
                break;
            }
            case VCF: {
                boolean parseGenotype;
                workflow.addTask(new ConvertVCF2GTBTask(inputsOptions, vcfQualityControlOptions, processedVariantFileMeta, showGTY_QCMetrics, workspace, true));
                workflow.execute();
                workflow.clearTasks();
                processedVariantFileMeta = (VariantFileMeta)workflow.getParam("ConvertedOriginalGTBInputVariantFileSet");
                GTBManager manger = processedVariantFileMeta.getGTB();
                boolean bl = parseGenotype = manger.getIndividuals() != null && !manger.getIndividuals().isEmpty();
                if (parseGenotype) {
                    if (fileID < 0) {
                        workflow.addTask(new GenerateAnnotationBaseTask(inputsOptions, vcfQualityControlOptions, workspace, saveGTY, true, newlyGeneratedFileNum));
                    } else {
                        workflow.addTask(new GenerateAnnotationBaseTask(inputsOptions, vcfQualityControlOptions, workspace, saveGTY, true, fileID, newlyGeneratedFileNum));
                    }
                } else if (fileID < 0) {
                    workflow.addTask(new GenerateAnnotationBaseNoGtyTask(inputsOptions, vcfQualityControlOptions, workspace, null, processedVariantFileMeta.refG, true));
                } else {
                    workflow.addTask(new GenerateAnnotationBaseNoGtyTask(inputsOptions, vcfQualityControlOptions, workspace, null, processedVariantFileMeta.refG, true, fileID));
                }
                workflow.execute();
                workflow.clearTasks();
                gtbManagers.add((GTBManager)workflow.getParam("OutputManager"));
                File gtyFile = (File)workflow.getParam("OutputGTYFile");
                if (gtyFile == null) break;
                gtyFiles.add(gtyFile);
                break;
            }
            case GTB: {
                boolean parseGenotype;
                workflow.setParam("ConvertedOriginalGTBInputVariantFileSet", processedVariantFileMeta);
                GTBManager manger = processedVariantFileMeta.getGTB();
                boolean bl = parseGenotype = manger.getIndividuals() != null && !manger.getIndividuals().isEmpty();
                if (parseGenotype) {
                    if (fileID < 0) {
                        workflow.addTask(new GenerateAnnotationBaseTask(inputsOptions, vcfQualityControlOptions, workspace, saveGTY, true, newlyGeneratedFileNum));
                    } else {
                        workflow.addTask(new GenerateAnnotationBaseTask(inputsOptions, vcfQualityControlOptions, workspace, saveGTY, true, fileID, newlyGeneratedFileNum));
                    }
                } else if (fileID < 0) {
                    workflow.addTask(new GenerateAnnotationBaseNoGtyTask(inputsOptions, vcfQualityControlOptions, workspace, null, processedVariantFileMeta.refG, true));
                } else {
                    workflow.addTask(new GenerateAnnotationBaseNoGtyTask(inputsOptions, vcfQualityControlOptions, workspace, null, processedVariantFileMeta.refG, true, fileID));
                }
                workflow.execute();
                workflow.clearTasks();
                gtbManagers.add((GTBManager)workflow.getParam("OutputManager"));
                File gtyFile = (File)workflow.getParam("OutputGTYFile");
                if (gtyFile == null) break;
                gtyFiles.add(gtyFile);
            }
        }
    }

    public synchronized GTBManager generateAnnotationBase(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, Executor workflow, File workspace, List<VariantFileMeta> inputFiles) throws IOException {
        boolean saveGTY = false;
        boolean parseGenotype = false;
        List<GTBManager> managers = new List<GTBManager>();
        List<File> gtyFiles = new List<File>();
        AtomicInteger newlyGeneratedBaseFileNum = new AtomicInteger(0);
        int fileID = -1;
        if (inputFiles.size() > 1) {
            for (VariantFileMeta orgInput : inputFiles) {
                this.generate(inputsOptions, vcfQualityControlOptions, orgInput, workflow, workspace, managers, gtyFiles, ++fileID, newlyGeneratedBaseFileNum);
            }
        } else {
            this.generate(inputsOptions, vcfQualityControlOptions, inputFiles.get(0), workflow, workspace, managers, gtyFiles, fileID, newlyGeneratedBaseFileNum);
        }
        workflow.clearTasks();
        if (managers.isEmpty()) {
            throw new FileNotFoundException();
        }
        File outputAnnotFile = new File(FileUtils.getSubFile(workspace.getPath() + "/GenerateAnnotationBaseTask0/", InputOutputFileSet.getAnnotationFileName()));
        File outputGTYFile = new File(FileUtils.getSubFile(workspace.getPath() + "/GenerateAnnotationBaseTask0/", InputOutputFileSet.getAnnotationGtyFileName()));
        if (managers.size() == 1) {
            File file = new File(managers.get(0).getFile().getPath());
            file.renameTo(outputAnnotFile);
            this.annotationBaseGTB = new GTBManager(outputAnnotFile);
            if (!gtyFiles.isEmpty()) {
                gtyFiles.get(0).renameTo(outputGTYFile);
            }
        } else {
            Processor.setInputs(managers.apply(GTBInputOption::new)).setOutput(new GTBOutputOption(outputAnnotFile)).bridge(new Variant2Variant()).setListener(new InputOutputListener()).submit(inputsOptions.threads);
            this.annotationBaseGTB = new GTBManager(outputAnnotFile);
            if (!gtyFiles.isEmpty()) {
                List<GTBManager> gtyManagers = new List<GTBManager>();
                for (File file : gtyFiles) {
                    gtyManagers.add(new GTBManager(file));
                }
                Processor.setInputs(gtyManagers.apply(GTBInputOption::new)).setOutput(new GTBOutputOption(outputGTYFile)).bridge(new Variant2Variant()).setListener(new InputOutputListener()).submit(inputsOptions.threads);
            }
        }
        workflow.getLogger().info("{} variants that passed variant filtration are stored in {}.", (Object)this.annotationBaseGTB.numOfVariants(), (Object)outputAnnotFile.getPath());
        if (saveGTY) {
            GTBManager outputGTYManager = new GTBManager(outputGTYFile);
            workflow.getLogger().info("{} variants' genotypes are saved in {}.", (Object)outputGTYManager.numOfVariants(), (Object)outputGTYFile.getCanonicalPath());
        }
        return this.annotationBaseGTB;
    }
}

