/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.pipeline;

import edu.sysu.pmglab.annotation.database.DataBaseFactory;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Executor;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.MutationCountAnalysisOptions;
import edu.sysu.pmglab.kgga.command.pipeline.PreprocessingPipeline;
import edu.sysu.pmglab.kgga.command.pipeline.VCFQualityControlOptions;
import edu.sysu.pmglab.kgga.command.setting.AFGRESetting;
import edu.sysu.pmglab.kgga.command.setting.CountRegressionRunnerSetting;
import edu.sysu.pmglab.kgga.command.setting.VariantFileMeta;
import edu.sysu.pmglab.kgga.command.task.AFGRETask;
import edu.sysu.pmglab.kgga.command.task.AssignVar2GeneTask;
import edu.sysu.pmglab.kgga.command.task.GenerateReferenceAFGRETask;
import edu.sysu.pmglab.kgga.command.task.GenerateReferenceGeneFreqScoreTask;
import edu.sysu.pmglab.kgga.command.task.MergeVariantScoresTask;
import edu.sysu.pmglab.kgga.io.InputType;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.Map;

public enum ProcessBackgroundMutationPipeline {
    INSTANCE;


    public Executor generateBackgroundFrequencies(GeneralIOOptions inputsOptions, VCFQualityControlOptions vcfQualityControlOptions, AnnotationOptions annotationOptions, MutationCountAnalysisOptions mutationCountAnalysisOptions, Executor mainExecutor, File outputDir, List<String> scoreFields4Regression, List<String> freqFields4Regression) throws Exception {
        Executor subExecutor = new Executor();
        subExecutor.setParam("geneSymbolIDMap", mainExecutor.getParam("geneSymbolIDMap"));
        subExecutor.setParam("geneIDMap", mainExecutor.getParam("geneIDMap"));
        subExecutor.setParam("transcriptIDMap", mainExecutor.getParam("transcriptIDMap"));
        subExecutor.setParam("canonicalTranscriptIDSet", mainExecutor.getParam("canonicalTranscriptIDSet"));
        subExecutor.setParam("geneSubRegionLength", mainExecutor.getParam("geneSubRegionLength"));
        boolean calcAFGRE = mutationCountAnalysisOptions.afgre != null;
        File subWorkspace = FileUtils.getSubFile(outputDir, "ProcessBackgroundMutationPipeline");
        subWorkspace.mkdirs();
        Utility.addTrack(subExecutor, subWorkspace);
        List<VariantFileMeta> inputFilesSub = new List<VariantFileMeta>();
        List<DatabaseDescription> databaseDescriptions = annotationOptions.freqDatabase;
        if (databaseDescriptions == null || databaseDescriptions.isEmpty()) {
            throw new RuntimeException("No background allelic frequency reference databases are set!");
        }
        FieldGroupMetas annotatedFreqFields = new FieldGroupMetas();
        for (DatabaseDescription databaseDescription : databaseDescriptions) {
            Database<?, Variant> database = DataBaseFactory.instanceOf(databaseDescription);
            GTBDatabase gtbDatabase = (GTBDatabase)database;
            inputFilesSub.add(new VariantFileMeta(LiveFile.of(gtbDatabase.getReaderOption().getFile().getPath()), InputType.GTB, inputsOptions.globalAnnotationGenomeVersion, gtbDatabase.getReaderOption().getFile().getPath(), null, null));
            freqFields4Regression.addAll(List.wrap(database.getAllFieldNames()));
        }
        int threadNum = inputsOptions.threads;
        GTBManager annotationBasedGTB = PreprocessingPipeline.INSTANCE.generateAnnotationBase(inputsOptions, vcfQualityControlOptions, subExecutor, subWorkspace, inputFilesSub);
        subExecutor.execute();
        subExecutor.clearTasks();
        subExecutor.setParam("AnnotationBaseVariantSet", new File(annotationBasedGTB.getFile().getPath()));
        boolean forceNotFilterByFreq = calcAFGRE;
        subExecutor.addTask(new AnnotationPipeline(annotationOptions, subWorkspace, false, forceNotFilterByFreq, threadNum).build());
        subExecutor.addTask(new AssignVar2GeneTask(annotationOptions, subWorkspace, true, threadNum));
        subExecutor.execute();
        subExecutor.clearTasks();
        String[] mutationCountWeightScores = null;
        boolean useAFGREasRegressionWeight = false;
        CountRegressionRunnerSetting regressionSetting = mutationCountAnalysisOptions.countRegressionRunnerSetting;
        if (regressionSetting != null && (mutationCountWeightScores = regressionSetting.getWeightFields()).length > 0 && mutationCountWeightScores[0].equalsIgnoreCase("@AFGRE")) {
            useAFGREasRegressionWeight = true;
        }
        if (calcAFGRE) {
            AFGRESetting afgreOptions = mutationCountAnalysisOptions.afgre;
            String[] scoreFieldNamesAFGRE = afgreOptions.getFields();
            subExecutor.addTask(new GenerateReferenceAFGRETask(mutationCountAnalysisOptions, subWorkspace, scoreFieldNamesAFGRE, freqFields4Regression.toArray((T1[])new String[0]), true, inputsOptions.threads));
            subExecutor.execute();
            subExecutor.clearTasks();
            if (useAFGREasRegressionWeight) {
                Boolean updatedGReferenceSet = (Boolean)subExecutor.getParam("UpdatedBaseGeneSet");
                File generateReferenceAFGRETaskPath = (File)subExecutor.getParam(GenerateReferenceAFGRETask.class);
                subExecutor.addTask(new AFGRETask(annotationOptions, subWorkspace, generateReferenceAFGRETaskPath, updatedGReferenceSet, afgreOptions, freqFields4Regression.toArray((T1[])new String[0]), true, inputsOptions.threads));
                subExecutor.execute();
                subExecutor.clearTasks();
                Map groupedAFGREFieldMap = (Map)subExecutor.getParam("GroupedAFGREFieldMapForCombine");
                if (afgreOptions.getFields().length > 1 && afgreOptions.isCombine()) {
                    subExecutor.addTask(new MergeVariantScoresTask(subWorkspace, groupedAFGREFieldMap, true, inputsOptions.threads));
                    for (String str : groupedAFGREFieldMap.keySet()) {
                        scoreFields4Regression.add("Combined@" + str);
                    }
                } else {
                    for (Map.Entry entry : groupedAFGREFieldMap.entrySet()) {
                        scoreFields4Regression.addAll((String[])((Object[])entry.getValue()));
                    }
                }
            }
        }
        if (regressionSetting != null) {
            if (mutationCountWeightScores.length > 0 && !useAFGREasRegressionWeight) {
                boolean isCombine = regressionSetting.isCombine();
                String combinedScoreName = "Combined@MutationScore";
                if (isCombine && mutationCountWeightScores.length > 1) {
                    scoreFields4Regression.add(combinedScoreName);
                    THashMap<String, String[]> groupedFieldMap = new THashMap<String, String[]>();
                    groupedFieldMap.put("MutationScore", mutationCountWeightScores);
                    subExecutor.addTask(new MergeVariantScoresTask(subWorkspace, groupedFieldMap, true, inputsOptions.threads));
                } else {
                    scoreFields4Regression.addAll((String[])mutationCountWeightScores);
                }
            }
            subExecutor.addTask(new GenerateReferenceGeneFreqScoreTask(annotationOptions, mutationCountAnalysisOptions, subWorkspace, scoreFields4Regression.toArray((T1[])new String[0]), freqFields4Regression.toArray((T1[])new String[0]), true, inputsOptions.threads));
        }
        subExecutor.execute();
        subExecutor.clearTasks();
        return subExecutor;
    }
}

