/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.pipeline;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.setting.PhenotypeCausalSetting;
import edu.sysu.pmglab.kgga.command.setting.PhenotypeGeneSetting;
import edu.sysu.pmglab.kgga.command.setting.PhenotypeVariantSetting;
import edu.sysu.pmglab.kgga.command.setting.SamplingGroupSetting;
import edu.sysu.pmglab.kgga.command.setting.SamplingSetting;
import edu.sysu.pmglab.kgga.command.setting.SpatialGeneSetting;
import edu.sysu.pmglab.kgga.command.setting.TimingGeneModelSetting;
import edu.sysu.pmglab.kgga.command.setting.TimingGeneSetting;
import edu.sysu.pmglab.kgga.command.setting.XqtlGeneSetting;

public class SimulationOptions {
    final String groupName = "Simulation Options";
    @DynamicOption(names={"--phenotype-variants"}, repeated=true, args={"qtlPattern=", "heritability=", "prevalence=", "confounding="}, converter=PhenotypeVariantSetting.Converter.class)
    @OptionUsage(group="Simulation Options", format="--phenotype-variants qtlPattern=<pattern> heritability=<value> prevalence=<value> confounding=<value>", description={"Set the number of QTL, the effect model, heritability, prevalence and confounding contribution."})
    public List<PhenotypeVariantSetting> phenotypeVariantSetting;
    @DynamicOption(names={"--sampling"}, repeated=true, args={"sampleSize=", "caseProportion="}, converter=SamplingSetting.Converter.class)
    @OptionUsage(group="Simulation Options", format="--sampling sampleSize=<int> caseProportion=<float>", description={"Set total sample size, case proportion for binary trait."})
    public List<SamplingSetting> samplingSetting;
    @DynamicOption(names={"--sampling-group"}, args={"groupNum=", "overlapping=0"}, converter=SamplingGroupSetting.Converter.class)
    @OptionUsage(group="Simulation Options", format="--sampling-group groupNum=<int> overlapping=<float>", description={"Set number of sample groups, and sample overlapping proportion within a group."})
    public SamplingGroupSetting samplingGroupSetting;
    @DynamicOption(names={"--phenotype-causal"}, args={"causalEffect=", "causalHeritability=", "pleiotropyIVProportion=", "directPleiotropyHeritability=", "randPleiotropyHeritability="}, converter=PhenotypeCausalSetting.Converter.class)
    @OptionUsage(group="Simulation Options", format="--phenotype-causal causalEffect=<value> causalHeritability=<value>", description={"Specifies the causal effect of an exposure to an outcome phenotype, the proportion of causal genetic variance by exposure, the proportion of correlated pleiotropic variants, and the proportion of genetic variance of the outcome phenotype explained by correlated pleiotropic variants."})
    public PhenotypeCausalSetting phenotypeCausalSetting;
    @Option(names={"--xqtl-gene-file"}, type=FieldType.livefile)
    @OptionUsage(group="Simulation Options", format="--xqtl-gene-file <path/to/testing/sample>", description={"Set file path of genes with xQTLs."})
    public LiveFile xqtlGeneFile;
    @DynamicOption(names={"--xqtl-gene"}, args={"maxQTLNum=", "effectScale=", "heritability="}, converter=XqtlGeneSetting.Converter.class)
    @OptionUsage(group="Simulation Options", format="--xqtl-gene maxQTLNum=<integer> effectScale=<value> heritability=<value>", description={"Set maximal xQTL number, effect scale and total heritability of xQTL for each gene."})
    public XqtlGeneSetting xqtlGeneSetting = new XqtlGeneSetting();
    @DynamicOption(names={"--phenotype-gene"}, args={"maxDriverNum=", "heritability=", "prevalence="}, converter=PhenotypeGeneSetting.Converter.class)
    @OptionUsage(group="Simulation Options", format="--phenotype-gene maxDriverNum=<integer> heritability=<value> prevalence=<value>", description={"Set maximal number of driver genes and total heritability of phenotype variation explained by the genes and prevalence of a binary trait (if any)."})
    public PhenotypeGeneSetting phenotypeGeneSetting;
    @DynamicOption(names={"--timing-gene-model"}, args={"peakTime=", "scaleWidth=", "amplitude="}, converter=TimingGeneModelSetting.Converter.class)
    @OptionUsage(group="Simulation Options", format="--timing-gene-model peakTime=<value> scaleWidth=<value> amplitude=<value>", description={"Set peak time age, scale width, and amplitude of with time-specific expression."})
    public TimingGeneModelSetting timingGeneModelSetting;
    @DynamicOption(names={"--timing-gene"}, args={"startAge=", "endAge=", "ageInterval=", "sampleSizePerAge=", "maxTimingGenes=", "sampleNum="}, converter=TimingGeneSetting.Converter.class)
    @OptionUsage(group="Simulation Options", format="--timing-gene startAge=<int> endAge=<int> ageInterval=<value> sampleSizePerAge=<int> maxTimingGenes=<int>", description={"Set start age, end age, age interval, sample size of each age point, maximal number of genes and sample number with time-specific expression."})
    public TimingGeneSetting timingGeneSetting;
    @DynamicOption(names={"--spatial-gene"}, args={"chipSize=", "hotLocations=", "maxHotExpressionGeneNum=", "dropoutRate=", "chipNum="}, converter=SpatialGeneSetting.Converter.class)
    @OptionUsage(group="Simulation Options", format="--spatial-gene chipSize=<int> hotLocations=<loc1&loc2> maxHotExpressionGeneNum=<int> dropoutRate=<value> chipNum=<int>", description={"Set chip size, location of hot expression spots, maximal number of genes with location-specific expression, dropout rate and number of chips."})
    public SpatialGeneSetting spatialGeneSetting;
}

