/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.pipeline;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.toolkit.filter.IObjectObjectFilter;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOption;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.rule.ChainRule;
import edu.sysu.pmglab.commandParser.rule.CountRule;
import edu.sysu.pmglab.commandParser.usage.summary.IParsingSummary;
import edu.sysu.pmglab.commandParser.validator.range.Float_0_1_RangeValidator;
import edu.sysu.pmglab.commandParser.validator.range.Float_0_RangeValidator;
import edu.sysu.pmglab.commandParser.validator.range.Int_0_100_RangeValidator;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeADController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeDPController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeGQController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypePLController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.IVariantController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.VariantACController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.VariantAFController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.VariantANController;
import edu.sysu.pmglab.kgga.command.setting.CustomGtyFilter;
import edu.sysu.pmglab.kgga.command.setting.CustomInfoFilter;
import edu.sysu.pmglab.objectpool.Producer;
import edu.sysu.pmglab.runtimecompiler.JavaCompiler;
import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class VCFQualityControlOptions {
    private static final String group = "VCF Quality Control Options";
    @Option(names={"--disable-qc"}, type=FieldType.NULL)
    @OptionUsage(group="VCF Quality Control Options", description={"Disable all quality control methods."})
    public boolean disableQC = false;
    @Option(names={"--gty-gq"}, type=FieldType.varInt32, validator=Int_0_100_RangeValidator.class)
    @OptionUsage(group="VCF Quality Control Options", format="--gty-gq <minGq>", defaultTo="20", description={"Exclude genotypes with the minimal genotype quality (Phred Quality Score) per genotype < minGq.", "'0' means to disable this filter."})
    public int gtyGq = 20;
    @Option(names={"--gty-dp"}, type=FieldType.varInt32, validator=Int_0_100_RangeValidator.class)
    @OptionUsage(group="VCF Quality Control Options", format="--gty-dp <minDp>", defaultTo="8", description={"Exclude genotypes with the minimal read depth per genotype < minDp.", "'0' means to disable this filter."})
    public int gtyDp = 8;
    @Option(names={"--gty-pl"}, type=FieldType.varInt32, validator=Int_0_100_RangeValidator.class)
    @OptionUsage(group="VCF Quality Control Options", format="--gty-pl <minPl>", defaultTo="20", description={"Exclude genotypes with the second smallest normalized Phred-scaled likelihoods for genotypes < minPl. Otherwise, there would be confusing genotypes.", "'0' means to disable this filter."})
    public int gtyPl = 20;
    @Option(names={"--gty-ad-hom-ref"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class)
    @OptionUsage(group="VCF Quality Control Options", format="--gty-ad-hom-ref <maxAdHomRef>", defaultTo="0.05", description={"Exclude genotypes with the fraction of the reads carrying alternative allele > maxAdHomRef at a reference-allele homozygous genotype.", "'1' means to disable this filter."})
    public float gtyAdHomRef = 0.95f;
    @Option(names={"--gty-ad-hom-alt"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class)
    @OptionUsage(group="VCF Quality Control Options", format="--gty-ad-hom-alt <minAdHomAlt>", defaultTo="0.75", description={"Exclude genotypes with the fraction of the reads carrying alternative allele < minAdHomAlt at a alternative-allele homozygous genotype.", "'0' means to disable this filter."})
    public float gtyAdHomAlt = 0.75f;
    @Option(names={"--gty-ad-het"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class)
    @OptionUsage(group="VCF Quality Control Options", format="--gty-ad-het <minAdHet>", defaultTo="0.25", description={"Exclude genotypes with the fraction of the reads carrying alternative allele < minAdHet at a heterozygous genotype.", "'0' means to disable this filter."})
    public float gtyAdHet = 0.25f;
    @DynamicOption(names={"--gty-qc"}, args={"keyword", "rule", "default=RETAIN"}, repeated=true, converter=CustomGtyFilter.class)
    @OptionUsage(group="VCF Quality Control Options", format="--gty-qc <keyword> <rule> default=[RETAIN/DISCARD]", item={@UsageItem(key="Example", value={"--gty-qc keyword=DP rule=DP>=8"})}, description={"Exclude genotypes where the genotype quality metric corresponding to the keyword has not passed Java expression quality control.", "'default' is used to determine whether to retain or discard the genotype when a quality control parsing error occurs."})
    public List<IGenotypeController> gtyQc = new List(0);
    @Option(names={"--allele-num"}, type=FieldType.intInterval)
    @OptionUsage(group="VCF Quality Control Options", format="--allele-num <min>~<max>", description={"Exclude variants with the alternative allele number per variant outside the range [min, max]."})
    public IntInterval rangeOfAlleleNum = null;
    @Option(names={"--seq-ac"}, type=FieldType.intInterval)
    @OptionUsage(group="VCF Quality Control Options", format="--seq-ac <minAc>~<maxAc>", defaultTo="1~", description={"Exclude variants with the alternate allele count (AC) per variant outside the range [minAc, maxAc]."})
    public IntInterval ac = new IntInterval(1, Integer.MAX_VALUE);
    @Option(names={"--seq-an"}, type=FieldType.intInterval)
    @OptionUsage(group="VCF Quality Control Options", format="--seq-an <minAn>~<maxAn>", description={"Exclude variants with the non-missing allele number (AN) per variant outside the range [minAn, maxAn]."})
    public IntInterval an = null;
    @Option(names={"--seq-af"}, type=FieldType.floatInterval)
    @OptionUsage(group="VCF Quality Control Options", format="--seq-af <minAf>~<maxAf>", description={"Exclude variants with the alternate allele frequency (AF) per variant outside the range [minAf, maxAf]."})
    public FloatInterval af = null;
    @Option(names={"--seq-qual"}, type=FieldType.float32, validator=Float_0_RangeValidator.class)
    @OptionUsage(group="VCF Quality Control Options", format="--seq-qual <minQual>", defaultTo="30", description={"Exclude variants with the minimal overall sequencing quality score (Phred Quality Score) per variant < minQual.", "'0' means to disable this filter."})
    public float qual = 30.0f;
    @Option(names={"--seq-mq"}, type=FieldType.float32, validator=Float_0_RangeValidator.class)
    @OptionUsage(group="VCF Quality Control Options", format="--seq-mq <minMq>", defaultTo="20", description={"Exclude variants with the minimal overall mapping quality score (Mapping Quality Score) per variant < minMq.", "'0' means to disable this filter."})
    public float mq = 20.0f;
    @Option(names={"--seq-fs"}, type=FieldType.float32, validator=Float_0_RangeValidator.class)
    @OptionUsage(group="VCF Quality Control Options", format="--seq-fs <minFs>", defaultTo="100", description={"Exclude variants with the overall strand bias Phred-scaled p-value (using Fisher's exact test) per variant > maxFs.", "'100' means to disable this filter."})
    public float fs = 100.0f;
    @DynamicOption(names={"--seq-info"}, args={"keyword", "rule", "default=RETAIN"}, repeated=true, converter=CustomInfoFilter.class)
    @OptionUsage(group="VCF Quality Control Options", format="--seq-info <keyword> <rule> default=[RETAIN/DISCARD]", item={@UsageItem(key="Example", value={"--seq-info keyword=MQ rule=MQ.toFloat()>=20"})}, description={"Exclude variants where the value of the specified keyword in the INFO field does not pass the Java expression quality control.", "'default' is used to control whether to retain or discard the genotype when a quality control parsing error occurs."})
    public List<IVariantController> infoQC = new List(0);
    @Option(names={"--seq-filter"}, container=Container.LIST)
    @OptionUsage(item={@UsageItem(key="Example", value={"--seq-filter value.valueEquals(\"PASS\")"})}, description={"Exclude variants where the value of the specified keyword in the FILTER field does not pass the Java expression quality control."}, format="--seq-filter <rule> <rule> ...")
    public List<String> seqFilter = new List();

    public Map<String, Producer<IGenotypeController>> getGenotypeControllers() {
        if (this.disableQC) {
            return new THashMap<String, Producer<IGenotypeController>>(0);
        }
        THashMap<String, Producer<IGenotypeController>> controllers = new THashMap<String, Producer<IGenotypeController>>();
        if (this.gtyGq > 0) {
            controllers.put("GQ", () -> new GenotypeGQController(this.gtyGq));
        }
        if (this.gtyDp > 0) {
            controllers.put("DP", () -> new GenotypeDPController(this.gtyDp));
        }
        if (this.gtyPl > 0) {
            controllers.put("PL", () -> new GenotypePLController(this.gtyPl));
        }
        if (this.gtyAdHomRef != 1.0f || this.gtyAdHomAlt != 0.0f || this.gtyAdHet != 0.0f) {
            controllers.put("AD", () -> new GenotypeADController(this.gtyDp, this.gtyAdHomRef, this.gtyAdHomAlt, this.gtyAdHet));
        }
        return Collections.unmodifiableMap(controllers);
    }

    public Map<String, IVariantController> getVariantController() {
        if (this.disableQC) {
            return new THashMap<String, IVariantController>(0);
        }
        THashMap<String, IVariantController> controllers = new THashMap<String, IVariantController>();
        if (this.rangeOfAlleleNum != null) {
            controllers.put("ALLELE_NUM", new IVariantController(){

                @Override
                public String getKeyWord() {
                    return "ALLELE_NUM";
                }

                @Override
                public boolean filter(Variant variant) {
                    return VCFQualityControlOptions.this.rangeOfAlleleNum.contains(variant.numOfAlleles());
                }
            });
        }
        if (this.ac != null) {
            controllers.put("AC", new VariantACController(this.ac));
        }
        if (this.an != null) {
            controllers.put("AN", new VariantANController(this.an));
        }
        if (this.af != null) {
            controllers.put("AF", new VariantAFController(this.af));
        }
        if (this.qual > 0.0f) {
            controllers.put("QUAL", new IVariantController(){

                @Override
                public String getKeyWord() {
                    return "QUAL";
                }

                @Override
                public boolean filter(Variant variant) {
                    Bytes qual = (Bytes)variant.getProperty("VCF::QUAL");
                    if (qual == null || qual.length() == 1 && qual.valueEquals((byte)46)) {
                        return true;
                    }
                    return qual.toFloat() >= VCFQualityControlOptions.this.qual;
                }
            });
        }
        if (this.mq > 0.0f) {
            controllers.put("MQ", new IVariantController(){

                @Override
                public String getKeyWord() {
                    return "MQ";
                }

                @Override
                public boolean filter(Variant variant) {
                    Map INFO = (Map)variant.getProperty("VCF::INFO");
                    return INFO == null || !INFO.containsKey("MQ") || ((Bytes)INFO.get("MQ")).toFloat() >= VCFQualityControlOptions.this.mq;
                }
            });
        }
        if (this.fs >= 0.0f && this.fs < 100.0f) {
            controllers.put("FS", new IVariantController(){

                @Override
                public String getKeyWord() {
                    return "FS";
                }

                @Override
                public boolean filter(Variant variant) {
                    Map INFO = (Map)variant.getProperty("VCF::INFO");
                    return INFO == null || !INFO.containsKey("FS") || ((Bytes)INFO.get("FS")).toFloat() <= VCFQualityControlOptions.this.fs;
                }
            });
        }
        for (IVariantController infoQC : this.infoQC) {
            if (controllers.containsKey(infoQC.getKeyWord())) {
                throw new ParameterException("Duplicate variant filter: " + infoQC.getKeyWord());
            }
            controllers.put(infoQC.getKeyWord(), infoQC);
        }
        this.seqFilter = new List<String>(this.seqFilter).filter(s -> !s.isEmpty());
        if (this.seqFilter.size() == 1) {
            final String keyword = "FILTER";
            controllers.put(keyword, new IVariantController(){
                final Function<Bytes, Boolean> filter;
                {
                    this.filter = JavaCompiler.eval(VCFQualityControlOptions.this.seqFilter.fastGet(0), JavaCompiler.Param.of("value", Bytes.class), Boolean.class);
                }

                @Override
                public String getKeyWord() {
                    return keyword;
                }

                @Override
                public boolean filter(Variant variant) {
                    return this.filter.apply((Bytes)variant.getProperty("VCF::FILTER"));
                }
            });
        } else {
            int index = 1;
            for (final String rule : this.seqFilter) {
                if (rule.isEmpty()) continue;
                final String keyword = "FILTER_" + index++;
                controllers.put(keyword, new IVariantController(){
                    final Function<Bytes, Boolean> filter;
                    {
                        this.filter = JavaCompiler.eval(rule, JavaCompiler.Param.of("value", Bytes.class), Boolean.class);
                    }

                    @Override
                    public String getKeyWord() {
                        return keyword;
                    }

                    @Override
                    public boolean filter(Variant variant) {
                        return this.filter.apply((Bytes)variant.getProperty("VCF::FILTER"));
                    }
                });
            }
        }
        return Collections.unmodifiableMap(controllers);
    }

    public static class QCOptionsRule
    extends ChainRule {
        public QCOptionsRule() {
            super(options -> options.passed("--disable-qc"), new CountRule(count -> count == 0, "--gty-gq", "--gty-dp", "--gty-pl", "--gty-ad-hom-ref", "--gty-ad-hom-alt", "--gty-ad-het", "--gty-qc", "--allele-num", "--seq-ac", "--seq-an", "--seq-af", "--seq-qual", "--seq-mq", "--seq-fs", "--seq-info", "--seq-filter"));
        }

        public String toString() {
            return "The option '--disable-qc' cannot be used together with other quality control options (e.g., --gty-qc, --seq-ac)";
        }
    }

    public static enum QCOptionsDisplayFilter implements IObjectObjectFilter<CommandOptions, CommandOption<?>>
    {
        INSTANCE;

        final IObjectObjectFilter<CommandOptions, CommandOption<?>> rule = IParsingSummary.disableIf(commands -> commands.passed("--disable-qc"), "--gty-gq", "--gty-dp", "--gty-pl", "--gty-ad-hom-ref", "--gty-ad-hom-alt", "--gty-ad-het", "--gty-qc", "--allele-num", "--seq-ac", "--seq-an", "--seq-af", "--seq-qual", "--seq-mq", "--seq-fs", "--seq-info", "--seq-filter");

        @Override
        public boolean filter(CommandOptions options, CommandOption<?> option) {
            return this.rule.filter(options, option);
        }
    }
}

