/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.python.toolkit;

import cern.jet.stat.Gamma;
import edu.sysu.pmglab.container.list.DoubleList;
import java.io.IOException;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.linsol.svd.SolvePseudoInverseSvd_DDRM;

public enum CalculatePValueECS {
    INSTANCE;

    private static final double MIN_P_VALUE = Double.MIN_VALUE;
    private static final double MAX_P_VALUE = 0.9999999999999999;

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        System.out.println(Math.exp(-Math.log10(9.9E-324)));
    }

    public double pValueECS(DMatrixRMaj ldMatrix, DoubleList chiSquareValues) {
        int snpNum = chiSquareValues.size();
        if (snpNum == 1) {
            double p = Gamma.incompleteGammaComplement(0.5, chiSquareValues.get(0) / 2.0);
            return Math.max(Double.MIN_VALUE, Math.min(0.9999999999999999, p));
        }
        for (int i = 0; i < ldMatrix.numRows; ++i) {
            for (int j = 0; j < ldMatrix.numCols; ++j) {
                if (!(ldMatrix.get(i, j) < 0.001)) continue;
                ldMatrix.set(i, j, 0.0);
            }
        }
        DMatrixRMaj chiSquares = new DMatrixRMaj(snpNum, 1);
        DMatrixRMaj dfs = new DMatrixRMaj(snpNum, 1);
        for (int i = 0; i < snpNum; ++i) {
            chiSquares.set(i, 0, (float)chiSquareValues.get(i));
            dfs.set(i, 0, 1.0);
        }
        DMatrixRMaj[] effs = CalculatePValueECS.solveLinearEquation(ldMatrix, chiSquares, dfs);
        DMatrixRMaj eChiSquares = effs[0];
        DMatrixRMaj eDfs = effs[1];
        double eChiSquare = Math.max(CommonOps_DDRM.elementSum(eChiSquares), 0.0);
        double eDf = Math.max(CommonOps_DDRM.elementSum(eDfs), 0.001);
        double p = Gamma.incompleteGammaComplement(eDf / 2.0, eChiSquare / 2.0);
        return Math.max(Double.MIN_VALUE, Math.min(0.9999999999999999, p));
    }

    private static DMatrixRMaj[] solveLinearEquation(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj C) {
        DMatrixRMaj AInvers = A.createLike();
        if (!CommonOps_DDRM.invertSPD(A, AInvers)) {
            SolvePseudoInverseSvd_DDRM svd = new SolvePseudoInverseSvd_DDRM();
            svd.setA(A);
            svd.invert(AInvers);
        }
        DMatrixRMaj eChis1 = B.createLike();
        CommonOps_DDRM.mult(AInvers, B, eChis1);
        DMatrixRMaj eChis2 = C.createLike();
        CommonOps_DDRM.mult(AInvers, C, eChis2);
        return new DMatrixRMaj[]{eChis1, eChis2};
    }
}

