/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.python.toolkit;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.List;
import jep.DirectNDArray;

public class DirectNumpyBinaryArray {
    private final int size;
    private final ByteBuffer directBuffer;
    private final LongBuffer longView;
    private final List refs = new ArrayList();
    private static final int BITS_PER_ELEMENT = 1;
    private static final int ELEMENTS_PER_LONG = 64;

    public DirectNumpyBinaryArray(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("\u6570\u7ec4\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
        }
        this.size = size;
        int longCount = (size + 64 - 1) / 64;
        int bufferSize = 8 + longCount * 8;
        this.directBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.directBuffer.order(ByteOrder.BIG_ENDIAN);
        this.directBuffer.putInt(0, size);
        this.directBuffer.putInt(4, 0);
        int originalPosition = this.directBuffer.position();
        int originalLimit = this.directBuffer.limit();
        this.directBuffer.position(8);
        int remaining = this.directBuffer.remaining();
        ByteBuffer slicedView = this.directBuffer.duplicate();
        slicedView.limit(slicedView.position() + remaining);
        this.longView = slicedView.order(ByteOrder.BIG_ENDIAN).asLongBuffer();
        this.directBuffer.position(originalPosition);
        this.directBuffer.limit(originalLimit);
    }

    public int get(int index) {
        this.validateIndex(index);
        int longIndex = index / 64;
        int bitOffset = index % 64;
        long value = this.longView.get(longIndex);
        return (int)(value >>> bitOffset & 1L);
    }

    public void set(int index, int value) {
        this.validateIndex(index);
        if (value != 0 && value != 1) {
            throw new IllegalArgumentException("\u503c\u5fc5\u987b\u4e3a0\u62161");
        }
        int longIndex = index / 64;
        int bitOffset = index % 64;
        long current = this.longView.get(longIndex);
        long mask = 1L << bitOffset;
        long newValue = value == 1 ? current | mask : current & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.longView.put(longIndex, newValue);
    }

    public void setRange(int startIndex, int[] values2) {
        if (startIndex < 0 || startIndex + values2.length > this.size) {
            throw new IndexOutOfBoundsException("\u7d22\u5f15\u8d85\u51fa\u8303\u56f4");
        }
        for (int i = 0; i < values2.length; ++i) {
            this.set(startIndex + i, values2[i]);
        }
    }

    public DirectNDArray getAsDirectNDArray() {
        this.directBuffer.position(0);
        DirectNDArray<ByteBuffer> array = new DirectNDArray<ByteBuffer>(this.directBuffer);
        this.refs.add(array);
        return array;
    }

    public DirectNDArray getMetaDirectNDArray() {
        ByteBuffer metaBuffer = this.directBuffer.duplicate();
        metaBuffer.limit(8);
        return new DirectNDArray<ByteBuffer>(metaBuffer);
    }

    public DirectNDArray getDataDirectNDArray() {
        return new DirectNDArray<LongBuffer>(this.longView.duplicate());
    }

    private void validateIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("\u7d22\u5f15\u8d85\u51fa\u8303\u56f4: " + index + ", \u6570\u7ec4\u5927\u5c0f: " + this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public String toString(int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(this.size, n); ++i) {
            sb.append(this.get(i)).append("\t");
        }
        return sb.toString();
    }
}

