/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.python.toolkit;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.List;
import jep.DirectNDArray;

public class DirectNumpyGenotypeArray {
    private final int rows;
    private final int cols;
    private final ByteBuffer directBuffer;
    private final LongBuffer longView;
    private final List<DirectNDArray<?>> refs = new ArrayList();
    private static final int BITS_PER_ELEMENT = 2;
    private static final int ELEMENTS_PER_LONG = 32;

    public DirectNumpyGenotypeArray(int rows, int cols) {
        if (rows <= 0 || cols <= 0) {
            throw new IllegalArgumentException("\u884c\u6570\u548c\u5217\u6570\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
        }
        this.rows = rows;
        this.cols = cols;
        int totalElements = rows * cols;
        int size = (totalElements + 32 - 1) / 32;
        int bufferSize = 8 + size * 8;
        this.directBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.directBuffer.order(ByteOrder.BIG_ENDIAN);
        this.directBuffer.putInt(0, rows);
        this.directBuffer.putInt(4, cols);
        int originalPosition = this.directBuffer.position();
        int originalLimit = this.directBuffer.limit();
        this.directBuffer.position(8);
        this.directBuffer.limit(this.directBuffer.capacity());
        this.longView = this.directBuffer.duplicate().order(ByteOrder.BIG_ENDIAN).asLongBuffer();
        this.directBuffer.position(originalPosition);
        this.directBuffer.limit(originalLimit);
    }

    public int get(int i, int j) {
        this.validateIndex(i, j);
        int flatIndex = i * this.cols + j;
        int longIndex = flatIndex / 32;
        int bitOffset = flatIndex % 32 * 2;
        long value = this.longView.get(longIndex);
        return (int)(value >>> bitOffset & 3L);
    }

    public void set(int i, int j, int value) {
        this.validateIndex(i, j);
        if (value < 0 || value > 3) {
            throw new IllegalArgumentException("\u503c\u5fc5\u987b\u4e3a0\u30011\u30012\u62163(NaN)");
        }
        int flatIndex = i * this.cols + j;
        int longIndex = flatIndex / 32;
        int bitOffset = flatIndex % 32 * 2;
        long current = this.longView.get(longIndex);
        long mask = 3L << bitOffset ^ 0xFFFFFFFFFFFFFFFFL;
        long newBits = ((long)value & 3L) << bitOffset;
        this.longView.put(longIndex, current & mask | newBits);
    }

    public void setRow(int row, int[] values2) {
        if (values2.length != this.cols) {
            throw new IllegalArgumentException("\u6570\u503c\u957f\u5ea6\u4e0e\u5217\u6570\u4e0d\u5339\u914d");
        }
        for (int j = 0; j < this.cols; ++j) {
            this.set(row, j, values2[j]);
        }
    }

    public void setCol(int col, int[] values2) {
        if (values2.length != this.rows) {
            throw new IllegalArgumentException("\u6570\u503c\u957f\u5ea6\u4e0e\u884c\u6570\u4e0d\u5339\u914d");
        }
        for (int i = 0; i < this.rows; ++i) {
            this.set(i, col, values2[i]);
        }
    }

    public DirectNDArray<ByteBuffer> getAsDirectNDArray() {
        this.directBuffer.position(0);
        DirectNDArray<ByteBuffer> array = new DirectNDArray<ByteBuffer>(this.directBuffer);
        this.refs.add(array);
        return array;
    }

    public DirectNDArray<ByteBuffer> getMetaDirectNDArray() {
        ByteBuffer metaBuffer = this.directBuffer.duplicate();
        metaBuffer.limit(8);
        return new DirectNDArray<ByteBuffer>(metaBuffer);
    }

    public DirectNDArray<LongBuffer> getDataDirectNDArray() {
        LongBuffer dataBuffer = this.longView.duplicate();
        return new DirectNDArray<LongBuffer>(dataBuffer);
    }

    private void validateIndex(int i, int j) {
        if (i < 0 || i >= this.rows || j < 0 || j >= this.cols) {
            throw new IndexOutOfBoundsException("\u7d22\u5f15\u8d85\u51fa\u8303\u56f4: (" + i + ", " + j + ")");
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public String toString(int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(this.rows, n); ++i) {
            for (int j = 0; j < Math.min(this.cols, n); ++j) {
                sb.append(this.get(i, j)).append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

