/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Arrays;
import java.util.Map;

public class AFGRESetting {
    String[] fields = null;
    int[] cs = null;
    boolean combine = false;

    public String[] getFields() {
        return this.fields;
    }

    public int[] getCs() {
        return this.cs;
    }

    public boolean isCombine() {
        return this.combine;
    }

    private AFGRESetting(String[] fields, int[] cs, boolean combine) {
        this.fields = fields;
        this.cs = cs;
        this.combine = combine;
    }

    public String toString() {
        return "Value{fields=" + Arrays.toString(this.fields) + ", c=" + Arrays.toString(this.cs) + ", combine='" + (this.combine ? "y" : "n") + '\'' + '}';
    }

    public String getAllFields() {
        return "Value{fields=" + Arrays.toString(this.fields) + '}';
    }

    public static class Converter
    implements IDynamicConverter<AFGRESetting> {
        @Override
        public AFGRESetting convert(String name, Map<String, String> options) {
            String[] fieldNames = null;
            int[] cVs = null;
            boolean composite = false;
            String fieldNameOption = options.get("field");
            String scalesOption = options.get("scale");
            String compositeOption = options.get("combine").toUpperCase();
            if (fieldNameOption != null) {
                fieldNames = fieldNameOption.split(",");
            }
            if (scalesOption != null) {
                String[] cVsStr = scalesOption.split(",");
                cVs = new int[cVsStr.length];
                for (int i = 0; i < cVs.length; ++i) {
                    cVs[i] = Integer.parseInt(cVsStr[i]);
                }
            }
            if (compositeOption.startsWith("Y")) {
                composite = true;
            }
            if (fieldNames == null) {
                throw new ParameterException("Positional argument of --afgre follows keyword argument: <field> [c=10,100,1000] [combine=y]");
            }
            if (cVs == null) {
                throw new ParameterException("Positional argument of --afgre follows keyword argument: <field> [c=10,100,1000] [combine=y]");
            }
            if (!compositeOption.startsWith("N") && !compositeOption.startsWith("Y")) {
                throw new ParameterException("Invalid value of " + compositeOption + " for combine of -afgre");
            }
            return new AFGRESetting(fieldNames, cVs, composite);
        }
    }
}

