/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.setting;

import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import java.util.Arrays;
import java.util.Map;

public class AssociationOptionSetting {
    String[] associationMethod = null;
    boolean useSex = false;
    boolean standardBeta = false;
    int[] interactions = null;
    boolean useInter = false;
    int cell = 0;

    public AssociationOptionSetting(String[] associationMethod, boolean useSex, boolean useInter, int[] interactions, boolean standardBeta, int cell) {
        this.associationMethod = associationMethod;
        this.useSex = useSex;
        this.useInter = useInter;
        this.interactions = interactions;
        this.standardBeta = standardBeta;
        this.cell = cell;
    }

    public AssociationOptionSetting(String[] associationMethod) {
        this.associationMethod = associationMethod;
        this.useSex = false;
        this.useInter = false;
    }

    public String[] getAssociationMethod() {
        return this.associationMethod;
    }

    public boolean isUseInter() {
        return this.useInter;
    }

    public int[] getInteractionParameters() {
        return this.interactions;
    }

    public boolean isUseSex() {
        return this.useSex;
    }

    public boolean getStandardBeta() {
        return this.standardBeta;
    }

    public int getCell() {
        return this.cell;
    }

    public int hashCode() {
        String region = this.associationMethod == null ? "." : Arrays.toString(this.associationMethod);
        return region.hashCode();
    }

    public static class Converter
    implements IDynamicConverter<AssociationOptionSetting> {
        @Override
        public AssociationOptionSetting convert(String name, Map<String, String> options) {
            String correctFormat = "Positional argument of --assoc follows keyword argument: method=<method1>,<method2> [sex=y/n] [interaction=1,...] [standardBeta=y/n] [cell=<positive integer>] [missingValue=-9]";
            String[] methodNames = null;
            boolean useSex = false;
            boolean useInter = false;
            boolean standardBeta = false;
            int[] interactions = null;
            int cell = 0;
            String methodOption = options.get("method");
            String sexOption = options.get("sex");
            String interactionOptions = options.get("interaction");
            String standardBetaOption = options.get("standardBeta");
            String cellOption = options.get("minCell");
            if (methodOption != null) {
                if (methodOption.trim().isEmpty()) {
                    methodNames = new String[]{};
                    throw new ParameterException(correctFormat);
                }
                methodNames = methodOption.split(",");
            }
            if (sexOption != null && sexOption.toUpperCase().startsWith("Y")) {
                useSex = true;
                sexOption = sexOption.toUpperCase();
            }
            if (standardBetaOption != null && standardBetaOption.toUpperCase().startsWith("Y")) {
                standardBeta = true;
                standardBetaOption = standardBetaOption.toUpperCase();
            }
            if (interactionOptions != null && !interactionOptions.trim().isEmpty()) {
                String[] var1 = interactionOptions.split(",");
                interactions = new int[var1.length];
                for (int i = 0; i < var1.length; ++i) {
                    interactions[i] = Integer.parseInt(var1[i]);
                }
                useInter = true;
            }
            if (cellOption != null && !cellOption.isEmpty()) {
                if (Integer.parseInt(cellOption) < 0) {
                    throw new ParameterException(correctFormat);
                }
                cell = Integer.parseInt(cellOption);
            }
            return new AssociationOptionSetting(methodNames, useSex, useInter, interactions, standardBeta, cell);
        }
    }
}

